-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Active Dexterity skill gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AnimateWeapon"] = {
	name = "Animate Weapon",
	color = 2,
	description = "Animates a melee weapon to fight by your side. You cannot animate unidentified weapons.",
	skillTypes = { [36] = true, [12] = true, [9] = true, [21] = true, [2] = true, [18] = true, [49] = true, },
	minionSkillTypes = { [1] = true, [24] = true, [25] = true, [28] = true, [54] = true, [56] = true, },
	castTime = 0.8,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", nil) }),
		},
		["active_skill_damage_+%_final"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "MORE", nil) }),
		},
		["attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack) }),
		},
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_movement_velocity_+%", 2 },
	},
	stats = {
		"emerge_speed_+%",
		"animate_item_maximum_level_requirement",
		"active_skill_damage_+%_final",
		"attack_speed_+%",
		"base_skill_effect_duration",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"number_of_animated_weapons_allowed",
	},
	levels = {
		[1] = { 0, 9, 0, 0, 37500, 4, 6, 50, manaCost = 9, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 0, 11, 8, 2, 37500, 5, 8, 50, manaCost = 10, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 0, 14, 16, 4, 37500, 7, 10, 50, manaCost = 11, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 0, 18, 24, 6, 37500, 8, 12, 50, manaCost = 12, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 0, 22, 32, 8, 37500, 10, 15, 50, manaCost = 14, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 0, 26, 40, 10, 37500, 12, 18, 50, manaCost = 15, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 0, 31, 48, 12, 37500, 14, 21, 50, manaCost = 16, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 0, 35, 56, 14, 37500, 17, 25, 50, manaCost = 18, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 0, 40, 64, 16, 37500, 19, 29, 50, manaCost = 20, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 0, 44, 72, 18, 37500, 22, 34, 50, manaCost = 22, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 0, 49, 80, 20, 37500, 24, 37, 50, manaCost = 25, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 0, 53, 88, 22, 37500, 26, 39, 50, manaCost = 26, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 0, 58, 96, 24, 37500, 28, 41, 50, manaCost = 27, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 0, 62, 104, 26, 37500, 29, 44, 50, manaCost = 29, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 0, 66, 112, 28, 37500, 31, 46, 50, manaCost = 30, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 0, 70, 120, 30, 37500, 32, 49, 50, manaCost = 31, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 0, 74, 128, 32, 37500, 34, 51, 50, manaCost = 33, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 0, 78, 136, 34, 37500, 36, 53, 50, manaCost = 34, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 0, 82, 144, 36, 37500, 37, 55, 50, manaCost = 34, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 0, 100, 152, 38, 37500, 38, 56, 50, manaCost = 36, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 0, 100, 160, 40, 37500, 39, 58, 50, manaCost = 37, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 0, 100, 168, 42, 37500, 40, 60, 50, manaCost = 38, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 0, 100, 176, 44, 37500, 41, 61, 50, manaCost = 38, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 0, 100, 184, 46, 37500, 42, 63, 50, manaCost = 39, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 0, 100, 192, 48, 37500, 43, 64, 50, manaCost = 40, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 0, 100, 200, 50, 37500, 44, 66, 50, manaCost = 41, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 0, 100, 208, 52, 37500, 45, 67, 50, manaCost = 42, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 0, 100, 216, 54, 37500, 46, 69, 50, manaCost = 42, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 0, 100, 224, 56, 37500, 47, 71, 50, manaCost = 44, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 0, 100, 232, 58, 37500, 48, 72, 50, manaCost = 45, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["NewArcticArmour"] = {
	name = "Arctic Armour",
	color = 2,
	description = "Summons an icy barrier that chills enemies when they hit you. You drop chilled ground while moving, and take less Fire and Physical damage while stationary.",
	skillTypes = { [2] = true, [5] = true, [18] = true, [12] = true, [15] = true, [27] = true, [34] = true, [16] = true, },
	castTime = 0.5,
	statMap = {
		["new_arctic_armour_physical_damage_taken_when_hit_+%_final"] = {
			mod("PhysicalDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["new_arctic_armour_fire_damage_taken_when_hit_+%_final"] = {
			mod("FireDamageTakenWhenHit", "MORE", nil, 0, 0, { type = "Condition", var = "Stationary" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1 },
	},
	stats = {
		"chill_enemy_when_hit_duration_ms",
		"new_arctic_armour_physical_damage_taken_when_hit_+%_final",
		"new_arctic_armour_fire_damage_taken_when_hit_+%_final",
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 500, -8, -8, 2500, cooldown = 0.5, levelRequirement = 16, manaCost = 25, statInterpolation = { }, },
		[2] = { 500, -8, -8, 2600, cooldown = 0.5, levelRequirement = 20, manaCost = 25, statInterpolation = { }, },
		[3] = { 500, -9, -8, 2700, cooldown = 0.5, levelRequirement = 24, manaCost = 25, statInterpolation = { }, },
		[4] = { 500, -9, -8, 2800, cooldown = 0.5, levelRequirement = 28, manaCost = 25, statInterpolation = { }, },
		[5] = { 500, -9, -9, 2900, cooldown = 0.5, levelRequirement = 31, manaCost = 25, statInterpolation = { }, },
		[6] = { 500, -9, -9, 3000, cooldown = 0.5, levelRequirement = 34, manaCost = 25, statInterpolation = { }, },
		[7] = { 500, -10, -9, 3100, cooldown = 0.5, levelRequirement = 37, manaCost = 25, statInterpolation = { }, },
		[8] = { 500, -10, -9, 3200, cooldown = 0.5, levelRequirement = 40, manaCost = 25, statInterpolation = { }, },
		[9] = { 500, -10, -10, 3300, cooldown = 0.5, levelRequirement = 43, manaCost = 25, statInterpolation = { }, },
		[10] = { 500, -10, -10, 3400, cooldown = 0.5, levelRequirement = 46, manaCost = 25, statInterpolation = { }, },
		[11] = { 500, -11, -10, 3500, cooldown = 0.5, levelRequirement = 49, manaCost = 25, statInterpolation = { }, },
		[12] = { 500, -11, -10, 3600, cooldown = 0.5, levelRequirement = 52, manaCost = 25, statInterpolation = { }, },
		[13] = { 500, -11, -11, 3700, cooldown = 0.5, levelRequirement = 55, manaCost = 25, statInterpolation = { }, },
		[14] = { 500, -11, -11, 3800, cooldown = 0.5, levelRequirement = 58, manaCost = 25, statInterpolation = { }, },
		[15] = { 500, -12, -11, 3900, cooldown = 0.5, levelRequirement = 60, manaCost = 25, statInterpolation = { }, },
		[16] = { 500, -12, -11, 4000, cooldown = 0.5, levelRequirement = 62, manaCost = 25, statInterpolation = { }, },
		[17] = { 500, -12, -12, 4100, cooldown = 0.5, levelRequirement = 64, manaCost = 25, statInterpolation = { }, },
		[18] = { 500, -12, -12, 4200, cooldown = 0.5, levelRequirement = 66, manaCost = 25, statInterpolation = { }, },
		[19] = { 500, -13, -12, 4300, cooldown = 0.5, levelRequirement = 68, manaCost = 25, statInterpolation = { }, },
		[20] = { 500, -13, -12, 4400, cooldown = 0.5, levelRequirement = 70, manaCost = 25, statInterpolation = { }, },
		[21] = { 500, -13, -13, 4500, cooldown = 0.5, levelRequirement = 72, manaCost = 25, statInterpolation = { }, },
		[22] = { 500, -13, -13, 4600, cooldown = 0.5, levelRequirement = 74, manaCost = 25, statInterpolation = { }, },
		[23] = { 500, -14, -13, 4700, cooldown = 0.5, levelRequirement = 76, manaCost = 25, statInterpolation = { }, },
		[24] = { 500, -14, -13, 4800, cooldown = 0.5, levelRequirement = 78, manaCost = 25, statInterpolation = { }, },
		[25] = { 500, -14, -14, 4900, cooldown = 0.5, levelRequirement = 80, manaCost = 25, statInterpolation = { }, },
		[26] = { 500, -14, -14, 5000, cooldown = 0.5, levelRequirement = 82, manaCost = 25, statInterpolation = { }, },
		[27] = { 500, -15, -14, 5100, cooldown = 0.5, levelRequirement = 84, manaCost = 25, statInterpolation = { }, },
		[28] = { 500, -15, -14, 5200, cooldown = 0.5, levelRequirement = 86, manaCost = 25, statInterpolation = { }, },
		[29] = { 500, -15, -15, 5300, cooldown = 0.5, levelRequirement = 88, manaCost = 25, statInterpolation = { }, },
		[30] = { 500, -15, -15, 5400, cooldown = 0.5, levelRequirement = 90, manaCost = 25, statInterpolation = { }, },
	},
}
skills["Barrage"] = {
	name = "Barrage",
	color = 2,
	description = "After a short preparation time, you attack repeatedly with a ranged weapon. These attacks have a small randomised spread. Only works with Bows and Wands.",
	skillTypes = { [1] = true, [48] = true, [6] = true, [3] = true, [22] = true, [17] = true, [19] = true, },
	weaponTypes = {
		["Wand"] = true,
		["Bow"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "1 Projectile",
		},
		{
			name = "All Projectiles",
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			activeSkill.skillData.dpsMultiplier = output.ProjectileCount
		end
	end,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "projectile_damage_+%", 0.5 },
	},
	stats = {
		"number_of_additional_projectiles",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 3, damageMultiplier = -50, levelRequirement = 12, manaCost = 7, statInterpolation = { }, },
		[2] = { 3, damageMultiplier = -49.4, levelRequirement = 15, manaCost = 7, statInterpolation = { }, },
		[3] = { 3, damageMultiplier = -48.8, levelRequirement = 19, manaCost = 7, statInterpolation = { }, },
		[4] = { 3, damageMultiplier = -48.2, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { 3, damageMultiplier = -47.6, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { 3, damageMultiplier = -47, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { 3, damageMultiplier = -46.4, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { 3, damageMultiplier = -45.8, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { 3, damageMultiplier = -45.2, levelRequirement = 41, manaCost = 9, statInterpolation = { }, },
		[10] = { 3, damageMultiplier = -44.6, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[11] = { 3, damageMultiplier = -44, levelRequirement = 47, manaCost = 9, statInterpolation = { }, },
		[12] = { 3, damageMultiplier = -43.4, levelRequirement = 50, manaCost = 9, statInterpolation = { }, },
		[13] = { 3, damageMultiplier = -42.8, levelRequirement = 53, manaCost = 9, statInterpolation = { }, },
		[14] = { 3, damageMultiplier = -42.2, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[15] = { 3, damageMultiplier = -41.6, levelRequirement = 59, manaCost = 10, statInterpolation = { }, },
		[16] = { 3, damageMultiplier = -41, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 3, damageMultiplier = -40.4, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 3, damageMultiplier = -39.8, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 3, damageMultiplier = -39.2, levelRequirement = 68, manaCost = 11, statInterpolation = { }, },
		[20] = { 3, damageMultiplier = -38.6, levelRequirement = 70, manaCost = 11, statInterpolation = { }, },
		[21] = { 3, damageMultiplier = -38, levelRequirement = 72, manaCost = 11, statInterpolation = { }, },
		[22] = { 3, damageMultiplier = -37.4, levelRequirement = 74, manaCost = 11, statInterpolation = { }, },
		[23] = { 3, damageMultiplier = -36.8, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 3, damageMultiplier = -36.2, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 3, damageMultiplier = -35.6, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 3, damageMultiplier = -35, levelRequirement = 82, manaCost = 12, statInterpolation = { }, },
		[27] = { 3, damageMultiplier = -34.4, levelRequirement = 84, manaCost = 12, statInterpolation = { }, },
		[28] = { 3, damageMultiplier = -33.8, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 3, damageMultiplier = -33.2, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 3, damageMultiplier = -32.6, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["BearTrap"] = {
	name = "Bear Trap",
	color = 2,
	description = "Throws a trap that damages and immobilises a single enemy.",
	skillTypes = { [12] = true, [19] = true, [37] = true, [39] = true, [10] = true, },
	castTime = 1,
	baseFlags = {
		cast = true,
		trap = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "physical_damage_+%", 1 },
	},
	stats = {
		"is_trap",
		"base_trap_duration",
		"base_movement_velocity_+%",
		"secondary_minimum_base_physical_damage",
		"secondary_maximum_base_physical_damage",
		"trap_override_pvp_scaling_time_ms",
		"base_skill_is_trapped",
		"display_skill_deals_secondary_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 1, 16000, -300, 16, 22, 750, critChance = 5, manaCost = 11, damageEffectiveness = 2, cooldown = 3, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 1, 16000, -300, 20, 28, 750, critChance = 5, manaCost = 13, damageEffectiveness = 2, cooldown = 3, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 1, 16000, -300, 27, 38, 750, critChance = 5, manaCost = 15, damageEffectiveness = 2, cooldown = 3, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 1, 16000, -300, 35, 49, 750, critChance = 5, manaCost = 17, damageEffectiveness = 2, cooldown = 3, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 1, 16000, -300, 49, 69, 750, critChance = 5, manaCost = 20, damageEffectiveness = 2, cooldown = 3, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 1, 16000, -300, 67, 94, 750, critChance = 5, manaCost = 22, damageEffectiveness = 2, cooldown = 3, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 1, 16000, -300, 90, 126, 750, critChance = 5, manaCost = 24, damageEffectiveness = 2, cooldown = 3, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 1, 16000, -300, 119, 167, 750, critChance = 5, manaCost = 26, damageEffectiveness = 2, cooldown = 3, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 1, 16000, -300, 156, 218, 750, critChance = 5, manaCost = 28, damageEffectiveness = 2, cooldown = 3, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 1, 16000, -300, 202, 282, 750, critChance = 5, manaCost = 32, damageEffectiveness = 2, cooldown = 3, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 1, 16000, -300, 259, 363, 750, critChance = 5, manaCost = 35, damageEffectiveness = 2, cooldown = 3, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 1, 16000, -300, 331, 463, 750, critChance = 5, manaCost = 38, damageEffectiveness = 2, cooldown = 3, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 1, 16000, -300, 420, 587, 750, critChance = 5, manaCost = 39, damageEffectiveness = 2, cooldown = 3, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 1, 16000, -300, 530, 742, 750, critChance = 5, manaCost = 41, damageEffectiveness = 2, cooldown = 3, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 1, 16000, -300, 630, 881, 750, critChance = 5, manaCost = 42, damageEffectiveness = 2, cooldown = 3, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 1, 16000, -300, 746, 1045, 750, critChance = 5, manaCost = 43, damageEffectiveness = 2, cooldown = 3, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 1, 16000, -300, 883, 1236, 750, critChance = 5, manaCost = 44, damageEffectiveness = 2, cooldown = 3, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 1, 16000, -300, 1043, 1460, 750, critChance = 5, manaCost = 45, damageEffectiveness = 2, cooldown = 3, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 1, 16000, -300, 1230, 1721, 750, critChance = 5, manaCost = 46, damageEffectiveness = 2, cooldown = 3, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 1, 16000, -300, 1447, 2026, 750, critChance = 5, manaCost = 46, damageEffectiveness = 2, cooldown = 3, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 1, 16000, -300, 1613, 2258, 750, critChance = 5, manaCost = 47, damageEffectiveness = 2, cooldown = 3, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 1, 16000, -300, 1795, 2514, 750, critChance = 5, manaCost = 48, damageEffectiveness = 2, cooldown = 3, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 1, 16000, -300, 1998, 2797, 750, critChance = 5, manaCost = 49, damageEffectiveness = 2, cooldown = 3, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 1, 16000, -300, 2222, 3111, 750, critChance = 5, manaCost = 50, damageEffectiveness = 2, cooldown = 3, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 1, 16000, -300, 2470, 3458, 750, critChance = 5, manaCost = 50, damageEffectiveness = 2, cooldown = 3, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 1, 16000, -300, 2744, 3842, 750, critChance = 5, manaCost = 51, damageEffectiveness = 2, cooldown = 3, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 1, 16000, -300, 3047, 4266, 750, critChance = 5, manaCost = 52, damageEffectiveness = 2, cooldown = 3, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 1, 16000, -300, 3382, 4735, 750, critChance = 5, manaCost = 53, damageEffectiveness = 2, cooldown = 3, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 1, 16000, -300, 3753, 5254, 750, critChance = 5, manaCost = 54, damageEffectiveness = 2, cooldown = 3, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 1, 16000, -300, 4162, 5826, 750, critChance = 5, manaCost = 54, damageEffectiveness = 2, cooldown = 3, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["ChargedAttack"] = {
	name = "Blade Flurry",
	color = 2,
	description = "Repeatedly strike at enemies in a circle in front of you while channelling, dealing damage to and around the struck enemy. The damage is continually boosted while channelling. You unleash an additional strike for each stage reached once the channelling ends. Requires a Dagger, Claw or One-Handed Sword.",
	skillTypes = { [1] = true, [11] = true, [6] = true, [58] = true, [24] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "1 Stage",
		},
		{
			name = "6 Stages",
		},
		{
			name = "Release at 6 Stages",
		},
	},
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 14),
		mod("Damage", "MORE", 120, ModFlag.Attack, 0, { type = "SkillPart", skillPart = 2 }),
		skill("dpsMultiplier", 3, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"charged_attack_damage_per_stack_+%_final",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 60, 20, damageMultiplier = -55, levelRequirement = 28, manaCost = 4, statInterpolation = { }, },
		[2] = { 60, 20, damageMultiplier = -54.4, levelRequirement = 31, manaCost = 4, statInterpolation = { }, },
		[3] = { 60, 20, damageMultiplier = -53.8, levelRequirement = 34, manaCost = 4, statInterpolation = { }, },
		[4] = { 60, 20, damageMultiplier = -53.2, levelRequirement = 37, manaCost = 4, statInterpolation = { }, },
		[5] = { 60, 20, damageMultiplier = -52.6, levelRequirement = 40, manaCost = 4, statInterpolation = { }, },
		[6] = { 60, 20, damageMultiplier = -52, levelRequirement = 42, manaCost = 4, statInterpolation = { }, },
		[7] = { 60, 20, damageMultiplier = -51.4, levelRequirement = 44, manaCost = 4, statInterpolation = { }, },
		[8] = { 60, 20, damageMultiplier = -50.8, levelRequirement = 46, manaCost = 4, statInterpolation = { }, },
		[9] = { 60, 20, damageMultiplier = -50.2, levelRequirement = 48, manaCost = 4, statInterpolation = { }, },
		[10] = { 60, 20, damageMultiplier = -49.6, levelRequirement = 50, manaCost = 4, statInterpolation = { }, },
		[11] = { 60, 20, damageMultiplier = -49, levelRequirement = 52, manaCost = 4, statInterpolation = { }, },
		[12] = { 60, 20, damageMultiplier = -48.4, levelRequirement = 54, manaCost = 4, statInterpolation = { }, },
		[13] = { 60, 20, damageMultiplier = -47.8, levelRequirement = 56, manaCost = 4, statInterpolation = { }, },
		[14] = { 60, 20, damageMultiplier = -47.2, levelRequirement = 58, manaCost = 4, statInterpolation = { }, },
		[15] = { 60, 20, damageMultiplier = -46.6, levelRequirement = 60, manaCost = 4, statInterpolation = { }, },
		[16] = { 60, 20, damageMultiplier = -46, levelRequirement = 62, manaCost = 4, statInterpolation = { }, },
		[17] = { 60, 20, damageMultiplier = -45.4, levelRequirement = 64, manaCost = 4, statInterpolation = { }, },
		[18] = { 60, 20, damageMultiplier = -44.8, levelRequirement = 66, manaCost = 4, statInterpolation = { }, },
		[19] = { 60, 20, damageMultiplier = -44.2, levelRequirement = 68, manaCost = 4, statInterpolation = { }, },
		[20] = { 60, 20, damageMultiplier = -43.6, levelRequirement = 70, manaCost = 4, statInterpolation = { }, },
		[21] = { 60, 20, damageMultiplier = -43, levelRequirement = 72, manaCost = 4, statInterpolation = { }, },
		[22] = { 60, 20, damageMultiplier = -42.4, levelRequirement = 74, manaCost = 4, statInterpolation = { }, },
		[23] = { 60, 20, damageMultiplier = -41.8, levelRequirement = 76, manaCost = 4, statInterpolation = { }, },
		[24] = { 60, 20, damageMultiplier = -41.2, levelRequirement = 78, manaCost = 4, statInterpolation = { }, },
		[25] = { 60, 20, damageMultiplier = -40.6, levelRequirement = 80, manaCost = 4, statInterpolation = { }, },
		[26] = { 60, 20, damageMultiplier = -40, levelRequirement = 82, manaCost = 4, statInterpolation = { }, },
		[27] = { 60, 20, damageMultiplier = -39.4, levelRequirement = 84, manaCost = 4, statInterpolation = { }, },
		[28] = { 60, 20, damageMultiplier = -38.8, levelRequirement = 86, manaCost = 4, statInterpolation = { }, },
		[29] = { 60, 20, damageMultiplier = -38.2, levelRequirement = 88, manaCost = 4, statInterpolation = { }, },
		[30] = { 60, 20, damageMultiplier = -37.6, levelRequirement = 90, manaCost = 4, statInterpolation = { }, },
	},
}
skills["BladeVortex"] = {
	name = "Blade Vortex",
	color = 2,
	description = "This spell creates ethereal blades which orbit in an area around you, periodically dealing damage to all enemies in their radius. As more blades are added, the damage becomes greater and more frequent.",
	skillTypes = { [2] = true, [10] = true, [11] = true, [12] = true, [18] = true, [26] = true, [36] = true, [27] = true, },
	castTime = 0.5,
	parts = {
		{
			name = "0 Blades",
		},
		{
			name = "5 Blades",
		},
		{
			name = "10 Blades",
		},
		{
			name = "20 Blades",
		},
	},
	statMap = {
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		mod("Damage", "MORE", 150, ModFlag.Spell, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Damage", "MORE", 300, ModFlag.Spell, 0, { type = "SkillPart", skillPart = 3 }),
		mod("Damage", "MORE", 600, ModFlag.Spell, 0, { type = "SkillPart", skillPart = 4 }),
		skill("hitTimeOverride", 0.6, { type = "SkillPart", skillPart = 1 }),
		skill("hitTimeOverride", 0.4, { type = "SkillPart", skillPart = 2 }),
		skill("hitTimeOverride", 0.3, { type = "SkillPart", skillPart = 3 }),
		skill("hitTimeOverride", 0.2, { type = "SkillPart", skillPart = 4 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"maximum_number_of_spinning_blades",
		"base_blade_vortex_hit_rate_ms",
		"blade_vortex_hit_rate_+%_per_blade",
		"blade_vortex_damage_+%_per_blade_final",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"action_ignores_crit_tracking",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 7, 10, 5000, 20, 600, 10, 30, 0, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 12, manaCost = 6, statInterpolation = { }, },
		[2] = { 8, 12, 5000, 20, 600, 10, 30, 0, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 15, manaCost = 7, statInterpolation = { }, },
		[3] = { 11, 16, 5000, 20, 600, 10, 30, 0, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 19, manaCost = 8, statInterpolation = { }, },
		[4] = { 14, 20, 5000, 20, 600, 10, 30, 0, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 23, manaCost = 9, statInterpolation = { }, },
		[5] = { 17, 25, 5000, 20, 600, 10, 30, 1, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 27, manaCost = 10, statInterpolation = { }, },
		[6] = { 21, 32, 5000, 20, 600, 10, 30, 1, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 31, manaCost = 11, statInterpolation = { }, },
		[7] = { 26, 39, 5000, 20, 600, 10, 30, 1, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 35, manaCost = 12, statInterpolation = { }, },
		[8] = { 30, 45, 5000, 20, 600, 10, 30, 1, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 38, manaCost = 13, statInterpolation = { }, },
		[9] = { 35, 52, 5000, 20, 600, 10, 30, 1, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 41, manaCost = 13, statInterpolation = { }, },
		[10] = { 40, 60, 5000, 20, 600, 10, 30, 2, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 44, manaCost = 14, statInterpolation = { }, },
		[11] = { 46, 69, 5000, 20, 600, 10, 30, 2, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 47, manaCost = 14, statInterpolation = { }, },
		[12] = { 53, 79, 5000, 20, 600, 10, 30, 2, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 50, manaCost = 15, statInterpolation = { }, },
		[13] = { 60, 90, 5000, 20, 600, 10, 30, 2, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 53, manaCost = 16, statInterpolation = { }, },
		[14] = { 68, 103, 5000, 20, 600, 10, 30, 2, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 56, manaCost = 16, statInterpolation = { }, },
		[15] = { 78, 117, 5000, 20, 600, 10, 30, 3, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 59, manaCost = 17, statInterpolation = { }, },
		[16] = { 88, 133, 5000, 20, 600, 10, 30, 3, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 62, manaCost = 18, statInterpolation = { }, },
		[17] = { 96, 144, 5000, 20, 600, 10, 30, 3, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 64, manaCost = 18, statInterpolation = { }, },
		[18] = { 104, 157, 5000, 20, 600, 10, 30, 3, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 66, manaCost = 19, statInterpolation = { }, },
		[19] = { 113, 170, 5000, 20, 600, 10, 30, 3, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 68, manaCost = 19, statInterpolation = { }, },
		[20] = { 123, 185, 5000, 20, 600, 10, 30, 4, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 70, manaCost = 19, statInterpolation = { }, },
		[21] = { 133, 200, 5000, 20, 600, 10, 30, 4, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 72, manaCost = 20, statInterpolation = { }, },
		[22] = { 145, 217, 5000, 20, 600, 10, 30, 4, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 74, manaCost = 21, statInterpolation = { }, },
		[23] = { 157, 235, 5000, 20, 600, 10, 30, 4, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 76, manaCost = 21, statInterpolation = { }, },
		[24] = { 170, 254, 5000, 20, 600, 10, 30, 4, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 78, manaCost = 21, statInterpolation = { }, },
		[25] = { 183, 275, 5000, 20, 600, 10, 30, 5, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 80, manaCost = 22, statInterpolation = { }, },
		[26] = { 198, 298, 5000, 20, 600, 10, 30, 5, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 214, 322, 5000, 20, 600, 10, 30, 5, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 84, manaCost = 23, statInterpolation = { }, },
		[28] = { 232, 347, 5000, 20, 600, 10, 30, 5, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 86, manaCost = 23, statInterpolation = { }, },
		[29] = { 250, 375, 5000, 20, 600, 10, 30, 5, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 88, manaCost = 24, statInterpolation = { }, },
		[30] = { 270, 405, 5000, 20, 600, 10, 30, 6, damageEffectiveness = 0.3, critChance = 6, levelRequirement = 90, manaCost = 24, statInterpolation = { }, },
	},
}
skills["Bladefall"] = {
	name = "Bladefall",
	color = 2,
	description = "Ethereal weapons rain from the sky, dealing damage to enemies in a sequence of five volleys, each wider but less damaging than the last. Enemies can be hit multiple times where these overlap.",
	skillTypes = { [2] = true, [11] = true, [17] = true, [19] = true, [18] = true, [10] = true, [36] = true, [26] = true, },
	castTime = 0.8,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"bladefall_damage_per_stage_+%_final",
		"base_skill_area_of_effect_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 44, 65, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 28, manaCost = 13, statInterpolation = { }, },
		[2] = { 52, 78, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 31, manaCost = 14, statInterpolation = { }, },
		[3] = { 62, 93, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 34, manaCost = 15, statInterpolation = { }, },
		[4] = { 73, 110, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 37, manaCost = 16, statInterpolation = { }, },
		[5] = { 86, 129, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 40, manaCost = 17, statInterpolation = { }, },
		[6] = { 96, 144, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 42, manaCost = 18, statInterpolation = { }, },
		[7] = { 107, 160, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 44, manaCost = 18, statInterpolation = { }, },
		[8] = { 118, 177, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 46, manaCost = 19, statInterpolation = { }, },
		[9] = { 131, 197, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 48, manaCost = 19, statInterpolation = { }, },
		[10] = { 145, 218, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 50, manaCost = 20, statInterpolation = { }, },
		[11] = { 160, 241, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 52, manaCost = 21, statInterpolation = { }, },
		[12] = { 177, 266, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 54, manaCost = 21, statInterpolation = { }, },
		[13] = { 195, 293, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 56, manaCost = 22, statInterpolation = { }, },
		[14] = { 215, 323, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 58, manaCost = 22, statInterpolation = { }, },
		[15] = { 237, 356, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 60, manaCost = 23, statInterpolation = { }, },
		[16] = { 261, 392, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 62, manaCost = 24, statInterpolation = { }, },
		[17] = { 287, 431, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 64, manaCost = 24, statInterpolation = { }, },
		[18] = { 315, 473, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 66, manaCost = 25, statInterpolation = { }, },
		[19] = { 346, 519, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 68, manaCost = 25, statInterpolation = { }, },
		[20] = { 380, 570, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 70, manaCost = 26, statInterpolation = { }, },
		[21] = { 417, 625, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 72, manaCost = 27, statInterpolation = { }, },
		[22] = { 457, 685, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 74, manaCost = 27, statInterpolation = { }, },
		[23] = { 500, 750, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 76, manaCost = 28, statInterpolation = { }, },
		[24] = { 548, 821, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 78, manaCost = 28, statInterpolation = { }, },
		[25] = { 599, 899, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 80, manaCost = 29, statInterpolation = { }, },
		[26] = { 655, 983, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 82, manaCost = 30, statInterpolation = { }, },
		[27] = { 716, 1074, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 84, manaCost = 30, statInterpolation = { }, },
		[28] = { 782, 1174, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 86, manaCost = 31, statInterpolation = { }, },
		[29] = { 854, 1282, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 88, manaCost = 31, statInterpolation = { }, },
		[30] = { 933, 1399, -6, 0, damageEffectiveness = 0.9, critChance = 5, levelRequirement = 90, manaCost = 32, statInterpolation = { }, },
	},
}
skills["BlastRain"] = {
	name = "Blast Rain",
	color = 2,
	description = "Fires an arrow up in the air, which splits and rains down in a series of explosions over an area. The explosions will always overlap on the targeted area.",
	skillTypes = { [1] = true, [11] = true, [14] = true, [22] = true, [17] = true, [19] = true, [33] = true, [48] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "1 explosion",
		},
		{
			name = "4 explosions",
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("dpsMultiplier", 4, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_physical_damage_%_to_convert_to_fire",
		"base_skill_area_of_effect_+%",
		"blast_rain_number_of_blasts",
		"blast_rain_arrow_delay_ms",
		"base_is_projectile",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, 0, 4, 80, damageMultiplier = -60, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[2] = { 50, 0, 4, 80, damageMultiplier = -59.6, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[3] = { 50, 0, 4, 80, damageMultiplier = -59.2, levelRequirement = 34, manaCost = 8, statInterpolation = { }, },
		[4] = { 50, 0, 4, 80, damageMultiplier = -58.8, levelRequirement = 37, manaCost = 8, statInterpolation = { }, },
		[5] = { 50, 0, 4, 80, damageMultiplier = -58.4, levelRequirement = 40, manaCost = 9, statInterpolation = { }, },
		[6] = { 50, 0, 4, 80, damageMultiplier = -58, levelRequirement = 42, manaCost = 9, statInterpolation = { }, },
		[7] = { 50, 0, 4, 80, damageMultiplier = -57.6, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[8] = { 50, 0, 4, 80, damageMultiplier = -57.2, levelRequirement = 46, manaCost = 9, statInterpolation = { }, },
		[9] = { 50, 0, 4, 80, damageMultiplier = -56.8, levelRequirement = 48, manaCost = 9, statInterpolation = { }, },
		[10] = { 50, 0, 4, 80, damageMultiplier = -56.4, levelRequirement = 50, manaCost = 9, statInterpolation = { }, },
		[11] = { 50, 0, 4, 80, damageMultiplier = -56, levelRequirement = 52, manaCost = 9, statInterpolation = { }, },
		[12] = { 50, 0, 4, 80, damageMultiplier = -55.6, levelRequirement = 54, manaCost = 10, statInterpolation = { }, },
		[13] = { 50, 0, 4, 80, damageMultiplier = -55.2, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[14] = { 50, 0, 4, 80, damageMultiplier = -54.8, levelRequirement = 58, manaCost = 10, statInterpolation = { }, },
		[15] = { 50, 0, 4, 80, damageMultiplier = -54.4, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[16] = { 50, 0, 4, 80, damageMultiplier = -54, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 50, 0, 4, 80, damageMultiplier = -53.6, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 50, 0, 4, 80, damageMultiplier = -53.2, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 50, 0, 4, 80, damageMultiplier = -52.8, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 50, 0, 4, 80, damageMultiplier = -52.4, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 50, 0, 4, 80, damageMultiplier = -52, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 50, 0, 4, 80, damageMultiplier = -51.6, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 50, 0, 4, 80, damageMultiplier = -51.2, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 50, 0, 4, 80, damageMultiplier = -50.8, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 50, 0, 4, 80, damageMultiplier = -50.4, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 50, 0, 4, 80, damageMultiplier = -50, levelRequirement = 82, manaCost = 11, statInterpolation = { }, },
		[27] = { 50, 0, 4, 80, damageMultiplier = -49.6, levelRequirement = 84, manaCost = 11, statInterpolation = { }, },
		[28] = { 50, 0, 4, 80, damageMultiplier = -49.2, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 50, 0, 4, 80, damageMultiplier = -48.8, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 50, 0, 4, 80, damageMultiplier = -48.4, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["BlinkArrow"] = {
	name = "Blink Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, you are teleported to it and a clone is summoned at your old location. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [14] = true, [1] = true, [9] = true, [48] = true, [21] = true, [12] = true, [22] = true, [17] = true, [19] = true, [38] = true, },
	minionSkillTypes = { [1] = true, [3] = true, [48] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	minionList = {
		"Clone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		{ "base_arrow_speed_+%", 1.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"minion_damage_+%",
		"minion_maximum_life_+%",
		"active_skill_minion_damage_+%_final",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"base_is_projectile",
	},
	levels = {
		[1] = { 3000, 1, 0, 0, 75, 4, 24, cooldown = 3, levelRequirement = 10, manaCost = 14, statInterpolation = { }, },
		[2] = { 3000, 1, 6, 3, 75, 4, 27, cooldown = 3, levelRequirement = 13, manaCost = 14, statInterpolation = { }, },
		[3] = { 3000, 1, 12, 6, 75, 4, 30, cooldown = 3, levelRequirement = 17, manaCost = 15, statInterpolation = { }, },
		[4] = { 3000, 1, 18, 9, 75, 4, 33, cooldown = 3, levelRequirement = 21, manaCost = 15, statInterpolation = { }, },
		[5] = { 3000, 1, 24, 12, 75, 4, 35, cooldown = 3, levelRequirement = 25, manaCost = 15, statInterpolation = { }, },
		[6] = { 3000, 1, 30, 15, 75, 4, 38, cooldown = 3, levelRequirement = 29, manaCost = 16, statInterpolation = { }, },
		[7] = { 3000, 1, 36, 18, 75, 4, 40, cooldown = 3, levelRequirement = 33, manaCost = 16, statInterpolation = { }, },
		[8] = { 3000, 1, 42, 21, 75, 4, 43, cooldown = 3, levelRequirement = 36, manaCost = 16, statInterpolation = { }, },
		[9] = { 3000, 1, 48, 24, 75, 4, 46, cooldown = 3, levelRequirement = 39, manaCost = 16, statInterpolation = { }, },
		[10] = { 3000, 1, 54, 27, 75, 4, 48, cooldown = 3, levelRequirement = 42, manaCost = 17, statInterpolation = { }, },
		[11] = { 3000, 1, 60, 30, 75, 4, 50, cooldown = 3, levelRequirement = 45, manaCost = 17, statInterpolation = { }, },
		[12] = { 3000, 1, 66, 33, 75, 4, 52, cooldown = 3, levelRequirement = 48, manaCost = 17, statInterpolation = { }, },
		[13] = { 3000, 1, 72, 36, 75, 4, 54, cooldown = 3, levelRequirement = 51, manaCost = 17, statInterpolation = { }, },
		[14] = { 3000, 1, 78, 39, 75, 4, 56, cooldown = 3, levelRequirement = 54, manaCost = 18, statInterpolation = { }, },
		[15] = { 3000, 1, 84, 42, 75, 4, 58, cooldown = 3, levelRequirement = 57, manaCost = 18, statInterpolation = { }, },
		[16] = { 3000, 1, 90, 45, 75, 4, 60, cooldown = 3, levelRequirement = 60, manaCost = 18, statInterpolation = { }, },
		[17] = { 3000, 1, 96, 48, 75, 4, 62, cooldown = 3, levelRequirement = 63, manaCost = 19, statInterpolation = { }, },
		[18] = { 3000, 1, 102, 51, 75, 4, 64, cooldown = 3, levelRequirement = 66, manaCost = 19, statInterpolation = { }, },
		[19] = { 3000, 1, 108, 54, 75, 4, 66, cooldown = 3, levelRequirement = 68, manaCost = 20, statInterpolation = { }, },
		[20] = { 3000, 1, 114, 57, 75, 4, 68, cooldown = 3, levelRequirement = 70, manaCost = 20, statInterpolation = { }, },
		[21] = { 3000, 1, 120, 60, 75, 4, 70, cooldown = 3, levelRequirement = 72, manaCost = 21, statInterpolation = { }, },
		[22] = { 3000, 1, 126, 63, 75, 4, 72, cooldown = 3, levelRequirement = 74, manaCost = 21, statInterpolation = { }, },
		[23] = { 3000, 1, 132, 66, 75, 4, 74, cooldown = 3, levelRequirement = 76, manaCost = 22, statInterpolation = { }, },
		[24] = { 3000, 1, 138, 69, 75, 4, 76, cooldown = 3, levelRequirement = 78, manaCost = 22, statInterpolation = { }, },
		[25] = { 3000, 1, 144, 72, 75, 4, 78, cooldown = 3, levelRequirement = 80, manaCost = 22, statInterpolation = { }, },
		[26] = { 3000, 1, 150, 75, 75, 4, 80, cooldown = 3, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 3000, 1, 156, 78, 75, 4, 82, cooldown = 3, levelRequirement = 84, manaCost = 23, statInterpolation = { }, },
		[28] = { 3000, 1, 162, 81, 75, 4, 84, cooldown = 3, levelRequirement = 86, manaCost = 23, statInterpolation = { }, },
		[29] = { 3000, 1, 168, 84, 75, 4, 86, cooldown = 3, levelRequirement = 88, manaCost = 23, statInterpolation = { }, },
		[30] = { 3000, 1, 174, 87, 75, 4, 88, cooldown = 3, levelRequirement = 90, manaCost = 24, statInterpolation = { }, },
	},
}
skills["BloodRage"] = {
	name = "Blood Rage",
	color = 2,
	description = "Adds a buff that deals Physical Damage over time, while increasing Attack Speed and Life Leech. Killing an enemy while this buff is active refreshes the buff duration, and can grant a Frenzy Charge.",
	skillTypes = { [2] = true, [5] = true, [12] = true, [18] = true, [36] = true, },
	castTime = 0.25,
	statMap = {
		["life_leech_from_physical_attack_damage_permyriad"] = {
			mod("PhysicalDamageLifeLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 100,
		},
		["base_physical_damage_%_of_maximum_life_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "Life", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute"] = {
			mod("PhysicalDegen", "BASE", nil, 0, 0, { type = "PerStat", stat = "EnergyShield", div = 1}, { type = "GlobalEffect", effectType = "Buff" }),
			div = 6000,
		},
		["attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("thisIsNotABuff", true),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.25 },
	},
	stats = {
		"attack_speed_+%",
		"life_leech_from_physical_attack_damage_permyriad",
		"base_physical_damage_%_of_maximum_life_to_deal_per_minute",
		"base_physical_damage_%_of_maximum_energy_shield_to_deal_per_minute",
		"add_frenzy_charge_on_kill_%_chance",
		"base_skill_effect_duration",
		"skill_level",
	},
	levels = {
		[1] = { 5, 120, 240, 240, 25, 7000, 1, cooldown = 1, levelRequirement = 16, manaCost = 17, statInterpolation = { }, },
		[2] = { 6, 120, 240, 240, 25, 7200, 2, cooldown = 1, levelRequirement = 20, manaCost = 17, statInterpolation = { }, },
		[3] = { 6, 120, 240, 240, 25, 7400, 3, cooldown = 1, levelRequirement = 24, manaCost = 17, statInterpolation = { }, },
		[4] = { 7, 120, 240, 240, 25, 7600, 4, cooldown = 1, levelRequirement = 28, manaCost = 18, statInterpolation = { }, },
		[5] = { 7, 120, 240, 240, 25, 7800, 5, cooldown = 1, levelRequirement = 31, manaCost = 18, statInterpolation = { }, },
		[6] = { 8, 120, 240, 240, 25, 8000, 6, cooldown = 1, levelRequirement = 34, manaCost = 18, statInterpolation = { }, },
		[7] = { 8, 120, 240, 240, 25, 8200, 7, cooldown = 1, levelRequirement = 37, manaCost = 18, statInterpolation = { }, },
		[8] = { 9, 120, 240, 240, 25, 8400, 8, cooldown = 1, levelRequirement = 40, manaCost = 19, statInterpolation = { }, },
		[9] = { 9, 120, 240, 240, 25, 8600, 9, cooldown = 1, levelRequirement = 43, manaCost = 19, statInterpolation = { }, },
		[10] = { 10, 120, 240, 240, 25, 8800, 10, cooldown = 1, levelRequirement = 46, manaCost = 19, statInterpolation = { }, },
		[11] = { 10, 120, 240, 240, 25, 9000, 11, cooldown = 1, levelRequirement = 49, manaCost = 20, statInterpolation = { }, },
		[12] = { 11, 120, 240, 240, 25, 9200, 12, cooldown = 1, levelRequirement = 52, manaCost = 20, statInterpolation = { }, },
		[13] = { 11, 120, 240, 240, 25, 9400, 13, cooldown = 1, levelRequirement = 55, manaCost = 20, statInterpolation = { }, },
		[14] = { 12, 120, 240, 240, 25, 9600, 14, cooldown = 1, levelRequirement = 58, manaCost = 20, statInterpolation = { }, },
		[15] = { 12, 120, 240, 240, 25, 9800, 15, cooldown = 1, levelRequirement = 60, manaCost = 20, statInterpolation = { }, },
		[16] = { 13, 120, 240, 240, 25, 10000, 16, cooldown = 1, levelRequirement = 62, manaCost = 21, statInterpolation = { }, },
		[17] = { 13, 120, 240, 240, 25, 10200, 17, cooldown = 1, levelRequirement = 64, manaCost = 21, statInterpolation = { }, },
		[18] = { 14, 120, 240, 240, 25, 10400, 18, cooldown = 1, levelRequirement = 66, manaCost = 21, statInterpolation = { }, },
		[19] = { 14, 120, 240, 240, 25, 10600, 19, cooldown = 1, levelRequirement = 68, manaCost = 21, statInterpolation = { }, },
		[20] = { 15, 120, 240, 240, 25, 10800, 20, cooldown = 1, levelRequirement = 70, manaCost = 21, statInterpolation = { }, },
		[21] = { 15, 120, 240, 240, 25, 11000, 21, cooldown = 1, levelRequirement = 72, manaCost = 22, statInterpolation = { }, },
		[22] = { 16, 120, 240, 240, 25, 11200, 22, cooldown = 1, levelRequirement = 74, manaCost = 22, statInterpolation = { }, },
		[23] = { 16, 120, 240, 240, 25, 11400, 23, cooldown = 1, levelRequirement = 76, manaCost = 22, statInterpolation = { }, },
		[24] = { 17, 120, 240, 240, 25, 11600, 24, cooldown = 1, levelRequirement = 78, manaCost = 22, statInterpolation = { }, },
		[25] = { 17, 120, 240, 240, 25, 11800, 25, cooldown = 1, levelRequirement = 80, manaCost = 22, statInterpolation = { }, },
		[26] = { 18, 120, 240, 240, 25, 12000, 26, cooldown = 1, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 18, 120, 240, 240, 25, 12200, 27, cooldown = 1, levelRequirement = 84, manaCost = 23, statInterpolation = { }, },
		[28] = { 19, 120, 240, 240, 25, 12400, 28, cooldown = 1, levelRequirement = 86, manaCost = 23, statInterpolation = { }, },
		[29] = { 19, 120, 240, 240, 25, 12600, 29, cooldown = 1, levelRequirement = 88, manaCost = 23, statInterpolation = { }, },
		[30] = { 20, 120, 240, 240, 25, 12800, 30, cooldown = 1, levelRequirement = 90, manaCost = 23, statInterpolation = { }, },
	},
}
skills["BurningArrow"] = {
	name = "Burning Arrow",
	color = 2,
	description = "Fires an arrow that deals fire damage to its target and has an increased chance of igniting it.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [22] = true, [17] = true, [19] = true, [33] = true, [53] = true, [55] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "ignite_duration_+%", 3 },
	},
	stats = {
		"base_chance_to_ignite_%",
		"burn_damage_+%",
		"base_physical_damage_%_to_convert_to_fire",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 20, 10, 50, damageMultiplier = 50, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 20, 11, 50, damageMultiplier = 51.8, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { 20, 12, 50, damageMultiplier = 53.6, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { 20, 13, 50, damageMultiplier = 55.4, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { 20, 14, 50, damageMultiplier = 57.2, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { 20, 15, 50, damageMultiplier = 59, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { 20, 16, 50, damageMultiplier = 60.8, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { 20, 17, 50, damageMultiplier = 62.6, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { 20, 18, 50, damageMultiplier = 64.4, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { 20, 19, 50, damageMultiplier = 66.2, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { 20, 20, 50, damageMultiplier = 68, levelRequirement = 36, manaCost = 7, statInterpolation = { }, },
		[12] = { 20, 21, 50, damageMultiplier = 69.8, levelRequirement = 40, manaCost = 7, statInterpolation = { }, },
		[13] = { 20, 22, 50, damageMultiplier = 71.6, levelRequirement = 44, manaCost = 7, statInterpolation = { }, },
		[14] = { 20, 23, 50, damageMultiplier = 73.4, levelRequirement = 48, manaCost = 7, statInterpolation = { }, },
		[15] = { 20, 24, 50, damageMultiplier = 75.2, levelRequirement = 52, manaCost = 7, statInterpolation = { }, },
		[16] = { 20, 25, 50, damageMultiplier = 77, levelRequirement = 56, manaCost = 8, statInterpolation = { }, },
		[17] = { 20, 26, 50, damageMultiplier = 78.8, levelRequirement = 60, manaCost = 8, statInterpolation = { }, },
		[18] = { 20, 27, 50, damageMultiplier = 80.6, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[19] = { 20, 28, 50, damageMultiplier = 82.4, levelRequirement = 67, manaCost = 8, statInterpolation = { }, },
		[20] = { 20, 29, 50, damageMultiplier = 84.2, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { 20, 30, 50, damageMultiplier = 86, levelRequirement = 72, manaCost = 9, statInterpolation = { }, },
		[22] = { 20, 31, 50, damageMultiplier = 87.8, levelRequirement = 74, manaCost = 9, statInterpolation = { }, },
		[23] = { 20, 32, 50, damageMultiplier = 89.6, levelRequirement = 76, manaCost = 9, statInterpolation = { }, },
		[24] = { 20, 33, 50, damageMultiplier = 91.4, levelRequirement = 78, manaCost = 9, statInterpolation = { }, },
		[25] = { 20, 34, 50, damageMultiplier = 93.2, levelRequirement = 80, manaCost = 9, statInterpolation = { }, },
		[26] = { 20, 35, 50, damageMultiplier = 95, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { 20, 36, 50, damageMultiplier = 96.8, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { 20, 37, 50, damageMultiplier = 98.6, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { 20, 38, 50, damageMultiplier = 100.4, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { 20, 39, 50, damageMultiplier = 102.2, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["VaalBurningArrow"] = {
	name = "Vaal Burning Arrow",
	color = 2,
	description = "Fires an arrow that explodes, dealing fire damage to its target and other nearby enemies, with an increased chance of igniting them.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [22] = true, [17] = true, [19] = true, [11] = true, [43] = true, [33] = true, [55] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "ignite_duration_+%", 3 },
	},
	stats = {
		"base_chance_to_ignite_%",
		"burn_damage_+%",
		"base_physical_damage_%_to_convert_to_fire",
		"vaal_burning_arrow_explode_on_hit",
		"global_always_hit",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 20, 10, 50, damageMultiplier = 60, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 20, 11, 50, damageMultiplier = 62, levelRequirement = 2, statInterpolation = { }, },
		[3] = { 20, 12, 50, damageMultiplier = 64, levelRequirement = 4, statInterpolation = { }, },
		[4] = { 20, 13, 50, damageMultiplier = 66, levelRequirement = 7, statInterpolation = { }, },
		[5] = { 20, 14, 50, damageMultiplier = 68, levelRequirement = 11, statInterpolation = { }, },
		[6] = { 20, 15, 50, damageMultiplier = 70, levelRequirement = 16, statInterpolation = { }, },
		[7] = { 20, 16, 50, damageMultiplier = 72, levelRequirement = 20, statInterpolation = { }, },
		[8] = { 20, 17, 50, damageMultiplier = 74, levelRequirement = 24, statInterpolation = { }, },
		[9] = { 20, 18, 50, damageMultiplier = 76, levelRequirement = 28, statInterpolation = { }, },
		[10] = { 20, 19, 50, damageMultiplier = 78, levelRequirement = 32, statInterpolation = { }, },
		[11] = { 20, 20, 50, damageMultiplier = 80, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 20, 21, 50, damageMultiplier = 82, levelRequirement = 40, statInterpolation = { }, },
		[13] = { 20, 22, 50, damageMultiplier = 84, levelRequirement = 44, statInterpolation = { }, },
		[14] = { 20, 23, 50, damageMultiplier = 86, levelRequirement = 48, statInterpolation = { }, },
		[15] = { 20, 24, 50, damageMultiplier = 88, levelRequirement = 52, statInterpolation = { }, },
		[16] = { 20, 25, 50, damageMultiplier = 90, levelRequirement = 56, statInterpolation = { }, },
		[17] = { 20, 26, 50, damageMultiplier = 92, levelRequirement = 60, statInterpolation = { }, },
		[18] = { 20, 27, 50, damageMultiplier = 94, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 20, 28, 50, damageMultiplier = 96, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 20, 29, 50, damageMultiplier = 98, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 20, 30, 50, damageMultiplier = 100, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 20, 31, 50, damageMultiplier = 102, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 20, 32, 50, damageMultiplier = 104, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 20, 33, 50, damageMultiplier = 106, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 20, 34, 50, damageMultiplier = 108, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 20, 35, 50, damageMultiplier = 110, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 20, 36, 50, damageMultiplier = 112, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 20, 37, 50, damageMultiplier = 114, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 20, 38, 50, damageMultiplier = 116, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 20, 39, 50, damageMultiplier = 118, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["PoisonArrow"] = {
	name = "Caustic Arrow",
	color = 2,
	description = "Fires an arrow which deals additional chaos damage to enemies it hits, and creates a caustic cloud. Enemies in the cloud take chaos damage over time.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [11] = true, [12] = true, [17] = true, [19] = true, [22] = true, [40] = true, [50] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
		skill("radius", 20),
		skill("dotIsArea", true),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"physical_damage_%_to_add_as_chaos",
		"active_skill_base_radius_+",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 2800, 312, 30, 0, manaCost = 8, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 2900, 391, 31, 0, manaCost = 8, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 3000, 530, 32, 0, manaCost = 8, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 3100, 702, 33, 0, manaCost = 9, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 3200, 991, 34, 1, manaCost = 9, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 3300, 1365, 35, 1, manaCost = 9, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 3400, 1846, 36, 1, manaCost = 10, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 3500, 2462, 37, 1, manaCost = 10, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 3600, 3247, 38, 1, manaCost = 10, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 3700, 4243, 39, 2, manaCost = 11, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 3900, 5501, 40, 2, manaCost = 11, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 4000, 7088, 41, 2, manaCost = 12, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 4100, 9081, 42, 2, manaCost = 12, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 4200, 11578, 43, 2, manaCost = 13, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 4300, 13855, 44, 3, manaCost = 13, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 4400, 16542, 45, 3, manaCost = 14, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 4500, 19713, 46, 3, manaCost = 14, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 4600, 23449, 47, 3, manaCost = 15, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 4700, 27848, 48, 3, manaCost = 15, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 4800, 33020, 49, 4, manaCost = 16, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 5000, 36963, 50, 4, manaCost = 16, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 5100, 41352, 51, 4, manaCost = 17, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 5200, 46235, 52, 4, manaCost = 17, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 5300, 51667, 53, 4, manaCost = 18, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 5400, 57707, 54, 5, manaCost = 18, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 5500, 64421, 55, 5, manaCost = 19, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 5600, 71883, 56, 5, manaCost = 19, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 5700, 80172, 57, 5, manaCost = 20, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 5800, 89377, 58, 5, manaCost = 20, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 5900, 99599, 59, 6, manaCost = 21, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Cyclone"] = {
	name = "Cyclone",
	color = 2,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [24] = true, [38] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	statMap = {
		["cyclone_movement_speed_+%_final"] = {
			mod("MovementSpeed", "MORE", nil),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
		skill("radiusIsWeaponRange", true),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"cyclone_movement_speed_+%_final",
		"base_skill_number_of_additional_hits",
		"cyclone_first_hit_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, -30, 1, -50, damageMultiplier = -55, levelRequirement = 28, manaCost = 12, statInterpolation = { }, },
		[2] = { 50, -30, 1, -50, damageMultiplier = -54.4, levelRequirement = 31, manaCost = 12, statInterpolation = { }, },
		[3] = { 50, -30, 1, -50, damageMultiplier = -53.8, levelRequirement = 34, manaCost = 12, statInterpolation = { }, },
		[4] = { 50, -30, 1, -50, damageMultiplier = -53.2, levelRequirement = 37, manaCost = 12, statInterpolation = { }, },
		[5] = { 50, -30, 1, -50, damageMultiplier = -52.6, levelRequirement = 40, manaCost = 12, statInterpolation = { }, },
		[6] = { 50, -30, 1, -50, damageMultiplier = -52, levelRequirement = 42, manaCost = 12, statInterpolation = { }, },
		[7] = { 50, -30, 1, -50, damageMultiplier = -51.4, levelRequirement = 44, manaCost = 12, statInterpolation = { }, },
		[8] = { 50, -30, 1, -50, damageMultiplier = -50.8, levelRequirement = 46, manaCost = 12, statInterpolation = { }, },
		[9] = { 50, -30, 1, -50, damageMultiplier = -50.2, levelRequirement = 48, manaCost = 12, statInterpolation = { }, },
		[10] = { 50, -30, 1, -50, damageMultiplier = -49.6, levelRequirement = 50, manaCost = 12, statInterpolation = { }, },
		[11] = { 50, -30, 1, -50, damageMultiplier = -49, levelRequirement = 52, manaCost = 12, statInterpolation = { }, },
		[12] = { 50, -30, 1, -50, damageMultiplier = -48.4, levelRequirement = 54, manaCost = 12, statInterpolation = { }, },
		[13] = { 50, -30, 1, -50, damageMultiplier = -47.8, levelRequirement = 56, manaCost = 12, statInterpolation = { }, },
		[14] = { 50, -30, 1, -50, damageMultiplier = -47.2, levelRequirement = 58, manaCost = 12, statInterpolation = { }, },
		[15] = { 50, -30, 1, -50, damageMultiplier = -46.6, levelRequirement = 60, manaCost = 12, statInterpolation = { }, },
		[16] = { 50, -30, 1, -50, damageMultiplier = -46, levelRequirement = 62, manaCost = 12, statInterpolation = { }, },
		[17] = { 50, -30, 1, -50, damageMultiplier = -45.4, levelRequirement = 64, manaCost = 12, statInterpolation = { }, },
		[18] = { 50, -30, 1, -50, damageMultiplier = -44.8, levelRequirement = 66, manaCost = 12, statInterpolation = { }, },
		[19] = { 50, -30, 1, -50, damageMultiplier = -44.2, levelRequirement = 68, manaCost = 12, statInterpolation = { }, },
		[20] = { 50, -30, 1, -50, damageMultiplier = -43.6, levelRequirement = 70, manaCost = 12, statInterpolation = { }, },
		[21] = { 50, -30, 1, -50, damageMultiplier = -43, levelRequirement = 72, manaCost = 12, statInterpolation = { }, },
		[22] = { 50, -30, 1, -50, damageMultiplier = -42.4, levelRequirement = 74, manaCost = 12, statInterpolation = { }, },
		[23] = { 50, -30, 1, -50, damageMultiplier = -41.8, levelRequirement = 76, manaCost = 12, statInterpolation = { }, },
		[24] = { 50, -30, 1, -50, damageMultiplier = -41.2, levelRequirement = 78, manaCost = 12, statInterpolation = { }, },
		[25] = { 50, -30, 1, -50, damageMultiplier = -40.6, levelRequirement = 80, manaCost = 12, statInterpolation = { }, },
		[26] = { 50, -30, 1, -50, damageMultiplier = -40, levelRequirement = 82, manaCost = 12, statInterpolation = { }, },
		[27] = { 50, -30, 1, -50, damageMultiplier = -39.4, levelRequirement = 84, manaCost = 12, statInterpolation = { }, },
		[28] = { 50, -30, 1, -50, damageMultiplier = -38.8, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 50, -30, 1, -50, damageMultiplier = -38.2, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 50, -30, 1, -50, damageMultiplier = -37.6, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["VaalCyclone"] = {
	name = "Vaal Cyclone",
	color = 2,
	description = "Spin and attack in place, damaging nearby enemies and pulling others towards you.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [24] = true, [12] = true, [43] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"base_skill_effect_duration",
		"base_skill_number_of_additional_hits",
		"base_skill_area_of_effect_+%",
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { 100, 5000, 1, 50, damageMultiplier = -50, levelRequirement = 28, statInterpolation = { }, },
		[2] = { 100, 5000, 1, 50, damageMultiplier = -49.4, levelRequirement = 31, statInterpolation = { }, },
		[3] = { 100, 5000, 1, 50, damageMultiplier = -48.8, levelRequirement = 34, statInterpolation = { }, },
		[4] = { 100, 5000, 1, 50, damageMultiplier = -48.2, levelRequirement = 37, statInterpolation = { }, },
		[5] = { 100, 5000, 1, 50, damageMultiplier = -47.6, levelRequirement = 40, statInterpolation = { }, },
		[6] = { 100, 5000, 1, 50, damageMultiplier = -47, levelRequirement = 42, statInterpolation = { }, },
		[7] = { 100, 5000, 1, 50, damageMultiplier = -46.4, levelRequirement = 44, statInterpolation = { }, },
		[8] = { 100, 5000, 1, 50, damageMultiplier = -45.8, levelRequirement = 46, statInterpolation = { }, },
		[9] = { 100, 5000, 1, 50, damageMultiplier = -45.2, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 100, 5000, 1, 50, damageMultiplier = -44.6, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 100, 5000, 1, 50, damageMultiplier = -44, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 100, 5000, 1, 50, damageMultiplier = -43.4, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 100, 5000, 1, 50, damageMultiplier = -42.8, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 100, 5000, 1, 50, damageMultiplier = -42.2, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 100, 5000, 1, 50, damageMultiplier = -41.6, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 100, 5000, 1, 50, damageMultiplier = -41, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 100, 5000, 1, 50, damageMultiplier = -40.4, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 100, 5000, 1, 50, damageMultiplier = -39.8, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 100, 5000, 1, 50, damageMultiplier = -39.2, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 100, 5000, 1, 50, damageMultiplier = -38.6, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 100, 5000, 1, 50, damageMultiplier = -38, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, 5000, 1, 50, damageMultiplier = -37.4, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 100, 5000, 1, 50, damageMultiplier = -36.8, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 100, 5000, 1, 50, damageMultiplier = -36.2, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 100, 5000, 1, 50, damageMultiplier = -35.6, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 100, 5000, 1, 50, damageMultiplier = -35, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 100, 5000, 1, 50, damageMultiplier = -34.4, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 100, 5000, 1, 50, damageMultiplier = -33.8, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 100, 5000, 1, 50, damageMultiplier = -33.2, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 100, 5000, 1, 50, damageMultiplier = -32.6, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Desecrate"] = {
	name = "Desecrate",
	color = 2,
	description = "Desecrates the ground, summoning corpses and dealing chaos damage to all enemies in the area.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [36] = true, [40] = true, [26] = true, [50] = true, },
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cast_speed_+%", 1 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"desecrate_number_of_corpses_to_create",
		"desecrate_corpse_level",
		"is_area_damage",
	},
	levels = {
		[1] = { 5000, 490, 3, 20, cooldown = 5, levelRequirement = 16, manaCost = 8, statInterpolation = { }, },
		[2] = { 5000, 679, 3, 24, cooldown = 5, levelRequirement = 20, manaCost = 8, statInterpolation = { }, },
		[3] = { 5000, 923, 3, 26, cooldown = 5, levelRequirement = 24, manaCost = 9, statInterpolation = { }, },
		[4] = { 5000, 1238, 3, 29, cooldown = 5, levelRequirement = 28, manaCost = 9, statInterpolation = { }, },
		[5] = { 5000, 1532, 3, 32, cooldown = 5, levelRequirement = 31, manaCost = 10, statInterpolation = { }, },
		[6] = { 5000, 1885, 3, 35, cooldown = 5, levelRequirement = 34, manaCost = 11, statInterpolation = { }, },
		[7] = { 5000, 2308, 3, 38, cooldown = 5, levelRequirement = 37, manaCost = 12, statInterpolation = { }, },
		[8] = { 5000, 2815, 3, 41, cooldown = 5, levelRequirement = 40, manaCost = 12, statInterpolation = { }, },
		[9] = { 5000, 3421, 3, 44, cooldown = 5, levelRequirement = 43, manaCost = 13, statInterpolation = { }, },
		[10] = { 5000, 4143, 3, 47, cooldown = 5, levelRequirement = 46, manaCost = 14, statInterpolation = { }, },
		[11] = { 5000, 5004, 3, 50, cooldown = 5, levelRequirement = 49, manaCost = 15, statInterpolation = { }, },
		[12] = { 5000, 6028, 3, 53, cooldown = 5, levelRequirement = 52, manaCost = 16, statInterpolation = { }, },
		[13] = { 5000, 7244, 3, 56, cooldown = 5, levelRequirement = 55, manaCost = 17, statInterpolation = { }, },
		[14] = { 5000, 8686, 3, 59, cooldown = 5, levelRequirement = 58, manaCost = 18, statInterpolation = { }, },
		[15] = { 5000, 9794, 3, 63, cooldown = 5, levelRequirement = 60, manaCost = 18, statInterpolation = { }, },
		[16] = { 5000, 11033, 3, 67, cooldown = 5, levelRequirement = 62, manaCost = 18, statInterpolation = { }, },
		[17] = { 5000, 12420, 3, 71, cooldown = 5, levelRequirement = 64, manaCost = 19, statInterpolation = { }, },
		[18] = { 5000, 13970, 3, 75, cooldown = 5, levelRequirement = 66, manaCost = 19, statInterpolation = { }, },
		[19] = { 5000, 15703, 3, 100, cooldown = 5, levelRequirement = 68, manaCost = 20, statInterpolation = { }, },
		[20] = { 5000, 17640, 3, 100, cooldown = 5, levelRequirement = 70, manaCost = 20, statInterpolation = { }, },
		[21] = { 5000, 19803, 3, 100, cooldown = 5, levelRequirement = 72, manaCost = 21, statInterpolation = { }, },
		[22] = { 5000, 22218, 3, 100, cooldown = 5, levelRequirement = 74, manaCost = 22, statInterpolation = { }, },
		[23] = { 5000, 24913, 3, 100, cooldown = 5, levelRequirement = 76, manaCost = 22, statInterpolation = { }, },
		[24] = { 5000, 27920, 3, 100, cooldown = 5, levelRequirement = 78, manaCost = 22, statInterpolation = { }, },
		[25] = { 5000, 31273, 3, 100, cooldown = 5, levelRequirement = 80, manaCost = 23, statInterpolation = { }, },
		[26] = { 5000, 35012, 3, 100, cooldown = 5, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 5000, 39179, 3, 100, cooldown = 5, levelRequirement = 84, manaCost = 24, statInterpolation = { }, },
		[28] = { 5000, 43823, 3, 100, cooldown = 5, levelRequirement = 86, manaCost = 25, statInterpolation = { }, },
		[29] = { 5000, 48995, 3, 100, cooldown = 5, levelRequirement = 88, manaCost = 25, statInterpolation = { }, },
		[30] = { 5000, 54755, 3, 100, cooldown = 5, levelRequirement = 90, manaCost = 26, statInterpolation = { }, },
	},
}
skills["DetonateDead"] = {
	name = "Detonate Dead",
	color = 2,
	description = "Explodes an unused corpse, dealing fire damage to nearby enemies.",
	skillTypes = { [39] = true, [10] = true, [11] = true, [17] = true, [18] = true, [19] = true, [26] = true, [36] = true, [33] = true, },
	castTime = 0.8,
	preDamageFunc = function(activeSkill, output)
		local skillData = activeSkill.skillData
		if skillData.corpseLife then
			skillData.FireMin = skillData.FireMin + skillData.corpseLife * 0.06
			skillData.FireMax = skillData.FireMax + skillData.corpseLife * 0.06
		end
	end,
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("radius", 22),
	},
	qualityStats = {
		{ "base_cast_speed_+%", 1 },
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"is_area_damage",
		"display_skill_deals_secondary_damage",
		"damage_cannot_be_reflected",
	},
	levels = {
		[1] = { 6, 4, 5, 1, critChance = 5, levelRequirement = 4, manaCost = 7, statInterpolation = { }, },
		[2] = { 6, 5, 8, 1, critChance = 5, levelRequirement = 6, manaCost = 8, statInterpolation = { }, },
		[3] = { 6, 8, 11, 1, critChance = 5, levelRequirement = 9, manaCost = 9, statInterpolation = { }, },
		[4] = { 6, 9, 14, 1, critChance = 5, levelRequirement = 12, manaCost = 10, statInterpolation = { }, },
		[5] = { 6, 13, 19, 1, critChance = 5, levelRequirement = 16, manaCost = 11, statInterpolation = { }, },
		[6] = { 6, 17, 25, 1, critChance = 5, levelRequirement = 20, manaCost = 12, statInterpolation = { }, },
		[7] = { 6, 22, 33, 1, critChance = 5, levelRequirement = 24, manaCost = 14, statInterpolation = { }, },
		[8] = { 6, 28, 43, 1, critChance = 5, levelRequirement = 28, manaCost = 15, statInterpolation = { }, },
		[9] = { 6, 36, 54, 1, critChance = 5, levelRequirement = 32, manaCost = 17, statInterpolation = { }, },
		[10] = { 6, 46, 69, 1, critChance = 5, levelRequirement = 36, manaCost = 19, statInterpolation = { }, },
		[11] = { 6, 58, 87, 1, critChance = 5, levelRequirement = 40, manaCost = 21, statInterpolation = { }, },
		[12] = { 6, 72, 108, 1, critChance = 5, levelRequirement = 44, manaCost = 22, statInterpolation = { }, },
		[13] = { 6, 90, 135, 1, critChance = 5, levelRequirement = 48, manaCost = 23, statInterpolation = { }, },
		[14] = { 6, 111, 167, 1, critChance = 5, levelRequirement = 52, manaCost = 24, statInterpolation = { }, },
		[15] = { 6, 130, 195, 1, critChance = 5, levelRequirement = 55, manaCost = 25, statInterpolation = { }, },
		[16] = { 6, 152, 227, 1, critChance = 5, levelRequirement = 58, manaCost = 26, statInterpolation = { }, },
		[17] = { 6, 176, 265, 1, critChance = 5, levelRequirement = 61, manaCost = 27, statInterpolation = { }, },
		[18] = { 6, 205, 308, 1, critChance = 5, levelRequirement = 64, manaCost = 28, statInterpolation = { }, },
		[19] = { 6, 238, 357, 1, critChance = 5, levelRequirement = 67, manaCost = 29, statInterpolation = { }, },
		[20] = { 6, 276, 414, 1, critChance = 5, levelRequirement = 70, manaCost = 30, statInterpolation = { }, },
		[21] = { 6, 304, 456, 1, critChance = 5, levelRequirement = 72, manaCost = 31, statInterpolation = { }, },
		[22] = { 6, 335, 502, 1, critChance = 5, levelRequirement = 74, manaCost = 32, statInterpolation = { }, },
		[23] = { 6, 369, 553, 1, critChance = 5, levelRequirement = 76, manaCost = 33, statInterpolation = { }, },
		[24] = { 6, 406, 609, 1, critChance = 5, levelRequirement = 78, manaCost = 34, statInterpolation = { }, },
		[25] = { 6, 446, 669, 1, critChance = 5, levelRequirement = 80, manaCost = 34, statInterpolation = { }, },
		[26] = { 6, 491, 736, 1, critChance = 5, levelRequirement = 82, manaCost = 35, statInterpolation = { }, },
		[27] = { 6, 539, 809, 1, critChance = 5, levelRequirement = 84, manaCost = 36, statInterpolation = { }, },
		[28] = { 6, 592, 888, 1, critChance = 5, levelRequirement = 86, manaCost = 37, statInterpolation = { }, },
		[29] = { 6, 650, 975, 1, critChance = 5, levelRequirement = 88, manaCost = 38, statInterpolation = { }, },
		[30] = { 6, 713, 1070, 1, critChance = 5, levelRequirement = 90, manaCost = 38, statInterpolation = { }, },
	},
}
skills["VaalDetonateDead"] = {
	name = "Vaal Detonate Dead",
	color = 2,
	description = "Explodes an unused corpse, dealing fire damage to nearby enemies. Nearby corpses will also explode in a chain reaction.",
	skillTypes = { [39] = true, [10] = true, [11] = true, [17] = true, [18] = true, [19] = true, [26] = true, [43] = true, [33] = true, },
	castTime = 0.8,
	preDamageFunc = function(activeSkill, output)
		local skillData = activeSkill.skillData
		if skillData.corpseLife then
			skillData.FireMin = skillData.FireMin + skillData.corpseLife * 0.08
			skillData.FireMax = skillData.FireMax + skillData.corpseLife * 0.08
		end
	end,
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cast_speed_+%", 1 },
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"is_area_damage",
		"display_skill_deals_secondary_damage",
		"detonate_dead_chain_explode",
		"damage_cannot_be_reflected",
	},
	levels = {
		[1] = { 8, 3, 5, 1, critChance = 5, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 8, 5, 7, 1, critChance = 5, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 8, 7, 10, 1, critChance = 5, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 8, 8, 12, 1, critChance = 5, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 8, 11, 17, 1, critChance = 5, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 8, 15, 23, 1, critChance = 5, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 8, 20, 30, 1, critChance = 5, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 8, 26, 39, 1, critChance = 5, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 8, 33, 50, 1, critChance = 5, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 8, 42, 63, 1, critChance = 5, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 8, 53, 79, 1, critChance = 5, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 8, 66, 99, 1, critChance = 5, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 8, 82, 122, 1, critChance = 5, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 8, 101, 151, 1, critChance = 5, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 8, 118, 177, 1, critChance = 5, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 8, 138, 207, 1, critChance = 5, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 8, 160, 241, 1, critChance = 5, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 8, 186, 280, 1, critChance = 5, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 8, 216, 325, 1, critChance = 5, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 8, 251, 376, 1, critChance = 5, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 8, 276, 415, 1, critChance = 5, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 8, 304, 457, 1, critChance = 5, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 8, 335, 503, 1, critChance = 5, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 8, 369, 553, 1, critChance = 5, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 8, 406, 609, 1, critChance = 5, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 8, 446, 669, 1, critChance = 5, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 8, 490, 735, 1, critChance = 5, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 8, 538, 807, 1, critChance = 5, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 8, 591, 886, 1, critChance = 5, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 8, 649, 973, 1, critChance = 5, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["DoubleStrike"] = {
	name = "Double Strike",
	color = 2,
	description = "Performs two fast attacks on target enemy with your main hand melee weapon.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [25] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_skill_number_of_additional_hits",
	},
	levels = {
		[1] = { 1, damageMultiplier = -30, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 1, damageMultiplier = -28.6, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { 1, damageMultiplier = -27.2, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { 1, damageMultiplier = -25.8, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { 1, damageMultiplier = -24.4, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { 1, damageMultiplier = -23, levelRequirement = 16, manaCost = 5, statInterpolation = { }, },
		[7] = { 1, damageMultiplier = -21.6, levelRequirement = 20, manaCost = 5, statInterpolation = { }, },
		[8] = { 1, damageMultiplier = -20.2, levelRequirement = 24, manaCost = 5, statInterpolation = { }, },
		[9] = { 1, damageMultiplier = -18.8, levelRequirement = 28, manaCost = 5, statInterpolation = { }, },
		[10] = { 1, damageMultiplier = -17.4, levelRequirement = 32, manaCost = 5, statInterpolation = { }, },
		[11] = { 1, damageMultiplier = -16, levelRequirement = 36, manaCost = 5, statInterpolation = { }, },
		[12] = { 1, damageMultiplier = -14.6, levelRequirement = 40, manaCost = 5, statInterpolation = { }, },
		[13] = { 1, damageMultiplier = -13.2, levelRequirement = 44, manaCost = 5, statInterpolation = { }, },
		[14] = { 1, damageMultiplier = -11.8, levelRequirement = 48, manaCost = 5, statInterpolation = { }, },
		[15] = { 1, damageMultiplier = -10.4, levelRequirement = 52, manaCost = 5, statInterpolation = { }, },
		[16] = { 1, damageMultiplier = -9, levelRequirement = 56, manaCost = 5, statInterpolation = { }, },
		[17] = { 1, damageMultiplier = -7.6, levelRequirement = 60, manaCost = 5, statInterpolation = { }, },
		[18] = { 1, damageMultiplier = -6.2, levelRequirement = 64, manaCost = 5, statInterpolation = { }, },
		[19] = { 1, damageMultiplier = -4.8, levelRequirement = 67, manaCost = 5, statInterpolation = { }, },
		[20] = { 1, damageMultiplier = -3.4, levelRequirement = 70, manaCost = 5, statInterpolation = { }, },
		[21] = { 1, damageMultiplier = -2, levelRequirement = 72, manaCost = 5, statInterpolation = { }, },
		[22] = { 1, damageMultiplier = -0.6, levelRequirement = 74, manaCost = 5, statInterpolation = { }, },
		[23] = { 1, damageMultiplier = 0.8, levelRequirement = 76, manaCost = 5, statInterpolation = { }, },
		[24] = { 1, damageMultiplier = 2.2, levelRequirement = 78, manaCost = 5, statInterpolation = { }, },
		[25] = { 1, damageMultiplier = 3.6, levelRequirement = 80, manaCost = 5, statInterpolation = { }, },
		[26] = { 1, damageMultiplier = 5, levelRequirement = 82, manaCost = 5, statInterpolation = { }, },
		[27] = { 1, damageMultiplier = 6.4, levelRequirement = 84, manaCost = 5, statInterpolation = { }, },
		[28] = { 1, damageMultiplier = 7.8, levelRequirement = 86, manaCost = 5, statInterpolation = { }, },
		[29] = { 1, damageMultiplier = 9.2, levelRequirement = 88, manaCost = 5, statInterpolation = { }, },
		[30] = { 1, damageMultiplier = 10.6, levelRequirement = 90, manaCost = 5, statInterpolation = { }, },
	},
}
skills["VaalDoubleStrike"] = {
	name = "Vaal Double Strike",
	color = 2,
	description = "Performs two fast attacks on target enemy with your main hand melee weapon, and summons your double for a duration to continuously attack monsters in this fashion.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [25] = true, [28] = true, [24] = true, [12] = true, [43] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_skill_number_of_additional_hits",
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
	},
	levels = {
		[1] = { 1, 3600, 1, damageMultiplier = -30, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 1, 3700, 1, damageMultiplier = -29.2, levelRequirement = 2, statInterpolation = { }, },
		[3] = { 1, 3800, 1, damageMultiplier = -28.4, levelRequirement = 4, statInterpolation = { }, },
		[4] = { 1, 3900, 1, damageMultiplier = -27.6, levelRequirement = 7, statInterpolation = { }, },
		[5] = { 1, 4000, 1, damageMultiplier = -26.8, levelRequirement = 11, statInterpolation = { }, },
		[6] = { 1, 4100, 1, damageMultiplier = -26, levelRequirement = 16, statInterpolation = { }, },
		[7] = { 1, 4200, 1, damageMultiplier = -25.2, levelRequirement = 20, statInterpolation = { }, },
		[8] = { 1, 4300, 1, damageMultiplier = -24.4, levelRequirement = 24, statInterpolation = { }, },
		[9] = { 1, 4400, 1, damageMultiplier = -23.6, levelRequirement = 28, statInterpolation = { }, },
		[10] = { 1, 4500, 1, damageMultiplier = -22.8, levelRequirement = 32, statInterpolation = { }, },
		[11] = { 1, 4600, 1, damageMultiplier = -22, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 1, 4700, 1, damageMultiplier = -21.2, levelRequirement = 40, statInterpolation = { }, },
		[13] = { 1, 4800, 1, damageMultiplier = -20.4, levelRequirement = 44, statInterpolation = { }, },
		[14] = { 1, 4900, 1, damageMultiplier = -19.6, levelRequirement = 48, statInterpolation = { }, },
		[15] = { 1, 5000, 1, damageMultiplier = -18.8, levelRequirement = 52, statInterpolation = { }, },
		[16] = { 1, 5100, 1, damageMultiplier = -18, levelRequirement = 56, statInterpolation = { }, },
		[17] = { 1, 5200, 1, damageMultiplier = -17.2, levelRequirement = 60, statInterpolation = { }, },
		[18] = { 1, 5300, 1, damageMultiplier = -16.4, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 1, 5400, 1, damageMultiplier = -15.6, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 1, 5500, 1, damageMultiplier = -14.8, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 1, 5600, 1, damageMultiplier = -14, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 1, 5700, 1, damageMultiplier = -13.2, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 1, 5800, 1, damageMultiplier = -12.4, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 1, 5900, 1, damageMultiplier = -11.6, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 1, 6000, 1, damageMultiplier = -10.8, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 1, 6100, 1, damageMultiplier = -10, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 1, 6200, 1, damageMultiplier = -9.2, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 1, 6300, 1, damageMultiplier = -8.4, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 1, 6400, 1, damageMultiplier = -7.6, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 1, 6500, 1, damageMultiplier = -6.8, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["DualStrike"] = {
	name = "Dual Strike",
	color = 2,
	description = "Attacks with both weapons, dealing the damage of both in one strike. Dual wield only. Does not work with wands.",
	skillTypes = { [1] = true, [4] = true, [25] = true, [28] = true, [24] = true, [53] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { damageMultiplier = -15, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { damageMultiplier = -14, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { damageMultiplier = -13, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { damageMultiplier = -12, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { damageMultiplier = -11, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { damageMultiplier = -10, levelRequirement = 16, manaCost = 5, statInterpolation = { }, },
		[7] = { damageMultiplier = -9, levelRequirement = 20, manaCost = 5, statInterpolation = { }, },
		[8] = { damageMultiplier = -8, levelRequirement = 24, manaCost = 5, statInterpolation = { }, },
		[9] = { damageMultiplier = -7, levelRequirement = 28, manaCost = 5, statInterpolation = { }, },
		[10] = { damageMultiplier = -6, levelRequirement = 32, manaCost = 5, statInterpolation = { }, },
		[11] = { damageMultiplier = -5, levelRequirement = 36, manaCost = 5, statInterpolation = { }, },
		[12] = { damageMultiplier = -4, levelRequirement = 40, manaCost = 5, statInterpolation = { }, },
		[13] = { damageMultiplier = -3, levelRequirement = 44, manaCost = 5, statInterpolation = { }, },
		[14] = { damageMultiplier = -2, levelRequirement = 48, manaCost = 5, statInterpolation = { }, },
		[15] = { damageMultiplier = -1, levelRequirement = 52, manaCost = 5, statInterpolation = { }, },
		[16] = { manaCost = 5, levelRequirement = 56, statInterpolation = { }, },
		[17] = { damageMultiplier = 1, levelRequirement = 60, manaCost = 5, statInterpolation = { }, },
		[18] = { damageMultiplier = 2, levelRequirement = 64, manaCost = 5, statInterpolation = { }, },
		[19] = { damageMultiplier = 3, levelRequirement = 67, manaCost = 5, statInterpolation = { }, },
		[20] = { damageMultiplier = 4, levelRequirement = 70, manaCost = 5, statInterpolation = { }, },
		[21] = { damageMultiplier = 5, levelRequirement = 72, manaCost = 5, statInterpolation = { }, },
		[22] = { damageMultiplier = 6, levelRequirement = 74, manaCost = 5, statInterpolation = { }, },
		[23] = { damageMultiplier = 7, levelRequirement = 76, manaCost = 5, statInterpolation = { }, },
		[24] = { damageMultiplier = 8, levelRequirement = 78, manaCost = 5, statInterpolation = { }, },
		[25] = { damageMultiplier = 9, levelRequirement = 80, manaCost = 5, statInterpolation = { }, },
		[26] = { damageMultiplier = 10, levelRequirement = 82, manaCost = 5, statInterpolation = { }, },
		[27] = { damageMultiplier = 11, levelRequirement = 84, manaCost = 5, statInterpolation = { }, },
		[28] = { damageMultiplier = 12, levelRequirement = 86, manaCost = 5, statInterpolation = { }, },
		[29] = { damageMultiplier = 13, levelRequirement = 88, manaCost = 5, statInterpolation = { }, },
		[30] = { damageMultiplier = 14, levelRequirement = 90, manaCost = 5, statInterpolation = { }, },
	},
}
skills["ElementalHit"] = {
	name = "Elemental Hit",
	color = 2,
	description = "A standard attack (with any weapon) that adds damage of a random element.",
	skillTypes = { [1] = true, [6] = true, [3] = true, [22] = true, [17] = true, [19] = true, [25] = true, [28] = true, [24] = true, [33] = true, [34] = true, [35] = true, [48] = true, },
	castTime = 1,
	parts = {
		{
			name = "Added fire",
		},
		{
			name = "Added cold",
		},
		{
			name = "Added lightning",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("EnemyFreezeChance", "BASE", 10),
		mod("EnemyShockChance", "BASE", 10),
		mod("EnemyIgniteChance", "BASE", 10),
	},
	qualityStats = {
		{ "elemental_damage_+%", 1 },
	},
	stats = {
		"attack_minimum_base_fire_damage_for_elemental_hit",
		"attack_maximum_base_fire_damage_for_elemental_hit",
		"attack_minimum_base_cold_damage_for_elemental_hit",
		"attack_maximum_base_cold_damage_for_elemental_hit",
		"attack_minimum_base_lightning_damage_for_elemental_hit",
		"attack_maximum_base_lightning_damage_for_elemental_hit",
		"chance_to_freeze_shock_ignite_%",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 4, 8, 3, 6, 1, 13, 10, manaCost = 6, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 5, 9, 4, 7, 1, 14, 10, manaCost = 6, levelRequirement = 2, statInterpolation = { }, },
		[3] = { 6, 11, 5, 9, 1, 17, 10, manaCost = 6, levelRequirement = 4, statInterpolation = { }, },
		[4] = { 7, 14, 6, 11, 1, 23, 10, manaCost = 7, levelRequirement = 7, statInterpolation = { }, },
		[5] = { 10, 19, 8, 16, 2, 31, 10, manaCost = 7, levelRequirement = 11, statInterpolation = { }, },
		[6] = { 14, 27, 12, 22, 2, 44, 10, manaCost = 7, levelRequirement = 16, statInterpolation = { }, },
		[7] = { 18, 34, 15, 28, 3, 56, 10, manaCost = 8, levelRequirement = 20, statInterpolation = { }, },
		[8] = { 23, 43, 19, 35, 4, 70, 10, manaCost = 8, levelRequirement = 24, statInterpolation = { }, },
		[9] = { 28, 53, 23, 43, 5, 87, 10, manaCost = 8, levelRequirement = 28, statInterpolation = { }, },
		[10] = { 35, 64, 28, 53, 6, 106, 10, manaCost = 9, levelRequirement = 32, statInterpolation = { }, },
		[11] = { 42, 78, 34, 64, 7, 128, 10, manaCost = 9, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 50, 93, 41, 76, 8, 153, 10, manaCost = 9, levelRequirement = 40, statInterpolation = { }, },
		[13] = { 60, 111, 49, 91, 10, 183, 10, manaCost = 10, levelRequirement = 44, statInterpolation = { }, },
		[14] = { 71, 132, 58, 108, 11, 217, 10, manaCost = 10, levelRequirement = 48, statInterpolation = { }, },
		[15] = { 84, 156, 69, 127, 13, 256, 10, manaCost = 10, levelRequirement = 52, statInterpolation = { }, },
		[16] = { 99, 183, 81, 150, 16, 301, 10, manaCost = 11, levelRequirement = 56, statInterpolation = { }, },
		[17] = { 115, 214, 94, 175, 19, 352, 10, manaCost = 11, levelRequirement = 60, statInterpolation = { }, },
		[18] = { 135, 250, 110, 205, 22, 411, 10, manaCost = 11, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 151, 280, 123, 229, 24, 461, 10, manaCost = 11, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 169, 314, 138, 257, 27, 516, 10, manaCost = 12, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 182, 338, 149, 276, 29, 555, 10, manaCost = 12, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 196, 364, 160, 297, 31, 598, 10, manaCost = 12, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 211, 391, 172, 320, 34, 643, 10, manaCost = 12, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 226, 420, 185, 344, 36, 691, 10, manaCost = 13, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 243, 452, 199, 370, 39, 743, 10, manaCost = 13, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 261, 485, 214, 397, 42, 798, 10, manaCost = 13, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 281, 521, 230, 426, 45, 857, 10, manaCost = 13, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 301, 559, 246, 457, 48, 919, 10, manaCost = 14, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 323, 600, 264, 491, 52, 986, 10, manaCost = 14, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 346, 643, 283, 526, 56, 1057, 10, manaCost = 14, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["EtherealKnives"] = {
	name = "Ethereal Knives",
	color = 2,
	description = "Fires an arc of knives in front of the caster which deals physical damage.",
	skillTypes = { [2] = true, [10] = true, [3] = true, [18] = true, [17] = true, [19] = true, [26] = true, [36] = true, },
	castTime = 0.6,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_projectile_speed_+%", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"base_projectile_speed_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 4, 6, 9, 0, critChance = 6, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 5, 7, 9, 1, critChance = 6, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 6, 9, 9, 2, critChance = 6, levelRequirement = 4, manaCost = 7, statInterpolation = { }, },
		[4] = { 8, 12, 9, 3, critChance = 6, levelRequirement = 7, manaCost = 8, statInterpolation = { }, },
		[5] = { 12, 18, 9, 4, critChance = 6, levelRequirement = 11, manaCost = 9, statInterpolation = { }, },
		[6] = { 18, 27, 9, 5, critChance = 6, levelRequirement = 16, manaCost = 10, statInterpolation = { }, },
		[7] = { 24, 37, 9, 6, critChance = 6, levelRequirement = 20, manaCost = 11, statInterpolation = { }, },
		[8] = { 32, 49, 9, 7, critChance = 6, levelRequirement = 24, manaCost = 12, statInterpolation = { }, },
		[9] = { 42, 64, 9, 8, critChance = 6, levelRequirement = 28, manaCost = 13, statInterpolation = { }, },
		[10] = { 55, 82, 9, 9, critChance = 6, levelRequirement = 32, manaCost = 14, statInterpolation = { }, },
		[11] = { 70, 105, 9, 10, critChance = 6, levelRequirement = 36, manaCost = 16, statInterpolation = { }, },
		[12] = { 89, 134, 9, 11, critChance = 6, levelRequirement = 40, manaCost = 17, statInterpolation = { }, },
		[13] = { 112, 169, 9, 12, critChance = 6, levelRequirement = 44, manaCost = 18, statInterpolation = { }, },
		[14] = { 141, 212, 9, 13, critChance = 6, levelRequirement = 48, manaCost = 18, statInterpolation = { }, },
		[15] = { 176, 265, 9, 14, critChance = 6, levelRequirement = 52, manaCost = 19, statInterpolation = { }, },
		[16] = { 219, 329, 9, 15, critChance = 6, levelRequirement = 56, manaCost = 20, statInterpolation = { }, },
		[17] = { 272, 408, 9, 16, critChance = 6, levelRequirement = 60, manaCost = 21, statInterpolation = { }, },
		[18] = { 336, 504, 9, 17, critChance = 6, levelRequirement = 64, manaCost = 22, statInterpolation = { }, },
		[19] = { 393, 590, 9, 18, critChance = 6, levelRequirement = 67, manaCost = 22, statInterpolation = { }, },
		[20] = { 459, 688, 9, 19, critChance = 6, levelRequirement = 70, manaCost = 23, statInterpolation = { }, },
		[21] = { 509, 763, 9, 20, critChance = 6, levelRequirement = 72, manaCost = 24, statInterpolation = { }, },
		[22] = { 563, 845, 9, 21, critChance = 6, levelRequirement = 74, manaCost = 24, statInterpolation = { }, },
		[23] = { 623, 935, 9, 22, critChance = 6, levelRequirement = 76, manaCost = 25, statInterpolation = { }, },
		[24] = { 690, 1034, 9, 23, critChance = 6, levelRequirement = 78, manaCost = 25, statInterpolation = { }, },
		[25] = { 762, 1144, 9, 24, critChance = 6, levelRequirement = 80, manaCost = 26, statInterpolation = { }, },
		[26] = { 842, 1264, 9, 25, critChance = 6, levelRequirement = 82, manaCost = 26, statInterpolation = { }, },
		[27] = { 931, 1396, 9, 26, critChance = 6, levelRequirement = 84, manaCost = 27, statInterpolation = { }, },
		[28] = { 1027, 1541, 9, 27, critChance = 6, levelRequirement = 86, manaCost = 27, statInterpolation = { }, },
		[29] = { 1134, 1701, 9, 28, critChance = 6, levelRequirement = 88, manaCost = 28, statInterpolation = { }, },
		[30] = { 1251, 1876, 9, 29, critChance = 6, levelRequirement = 90, manaCost = 29, statInterpolation = { }, },
	},
}
skills["ExplosiveArrow"] = {
	name = "Explosive Arrow",
	color = 2,
	description = "Fires an arrow which acts as a short duration fuse. Applying additional arrows to an enemy extends the duration. When the target dies or the fuses expire, the arrows explode, dealing fire AoE damage to nearby enemies. The AoE radius is proportional to the number of arrows upon death.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [10] = true, [11] = true, [12] = true, [22] = true, [17] = true, [19] = true, [33] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Explosion (1 fuse)",
			attack = false,
			area = true,
			cast = true,
		},
		{
			name = "Explosion (5 fuses)",
			attack = false,
			area = true,
			cast = true,
		},
		{
			name = "Arrow",
			attack = true,
			area = false,
			cast = false,
		},
	},
	statMap = {
		["minimum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMin", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["maximum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMax", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true, { type = "SkillPart", skillPart = 1 }),
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 1, 0, 0, { type = "SkillPart", skillPart = 1 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 5, 0, 0, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_chance_to_ignite_%", 1 },
	},
	stats = {
		"base_skill_effect_duration",
		"minimum_fire_damage_per_fuse_arrow_orb",
		"maximum_fire_damage_per_fuse_arrow_orb",
		"fuse_arrow_explosion_radius_+_per_fuse_arrow_orb",
		"active_skill_attack_damage_+%_final",
		"skill_can_fire_arrows",
		"base_is_projectile",
	},
	levels = {
		[1] = { 1000, 44, 66, 2, 0, 1, 1, critChance = 6, levelRequirement = 28, manaCost = 18, statInterpolation = { }, },
		[2] = { 1000, 54, 81, 2, 0, 1, 1, critChance = 6, levelRequirement = 31, manaCost = 19, statInterpolation = { }, },
		[3] = { 1000, 66, 99, 2, 0, 1, 1, critChance = 6, levelRequirement = 34, manaCost = 20, statInterpolation = { }, },
		[4] = { 1000, 80, 121, 2, 0, 1, 1, critChance = 6, levelRequirement = 37, manaCost = 21, statInterpolation = { }, },
		[5] = { 1000, 98, 146, 2, 0, 1, 1, critChance = 6, levelRequirement = 40, manaCost = 21, statInterpolation = { }, },
		[6] = { 1000, 111, 166, 2, 0, 1, 1, critChance = 6, levelRequirement = 42, manaCost = 22, statInterpolation = { }, },
		[7] = { 1000, 126, 189, 2, 0, 1, 1, critChance = 6, levelRequirement = 44, manaCost = 22, statInterpolation = { }, },
		[8] = { 1000, 142, 214, 2, 0, 1, 1, critChance = 6, levelRequirement = 46, manaCost = 23, statInterpolation = { }, },
		[9] = { 1000, 161, 242, 2, 0, 1, 1, critChance = 6, levelRequirement = 48, manaCost = 23, statInterpolation = { }, },
		[10] = { 1000, 182, 273, 2, 0, 1, 1, critChance = 6, levelRequirement = 50, manaCost = 24, statInterpolation = { }, },
		[11] = { 1000, 205, 308, 2, 0, 1, 1, critChance = 6, levelRequirement = 52, manaCost = 24, statInterpolation = { }, },
		[12] = { 1000, 232, 347, 2, 0, 1, 1, critChance = 6, levelRequirement = 54, manaCost = 24, statInterpolation = { }, },
		[13] = { 1000, 261, 391, 2, 0, 1, 1, critChance = 6, levelRequirement = 56, manaCost = 26, statInterpolation = { }, },
		[14] = { 1000, 293, 440, 2, 0, 1, 1, critChance = 6, levelRequirement = 58, manaCost = 26, statInterpolation = { }, },
		[15] = { 1000, 330, 495, 2, 0, 1, 1, critChance = 6, levelRequirement = 60, manaCost = 26, statInterpolation = { }, },
		[16] = { 1000, 371, 556, 2, 0, 1, 1, critChance = 6, levelRequirement = 62, manaCost = 26, statInterpolation = { }, },
		[17] = { 1000, 416, 624, 2, 0, 1, 1, critChance = 6, levelRequirement = 64, manaCost = 26, statInterpolation = { }, },
		[18] = { 1000, 467, 700, 2, 0, 1, 1, critChance = 6, levelRequirement = 66, manaCost = 27, statInterpolation = { }, },
		[19] = { 1000, 523, 785, 2, 0, 1, 1, critChance = 6, levelRequirement = 68, manaCost = 27, statInterpolation = { }, },
		[20] = { 1000, 586, 879, 2, 0, 1, 1, critChance = 6, levelRequirement = 70, manaCost = 27, statInterpolation = { }, },
		[21] = { 1000, 656, 984, 2, 0, 1, 1, critChance = 6, levelRequirement = 72, manaCost = 28, statInterpolation = { }, },
		[22] = { 1000, 734, 1100, 2, 0, 1, 1, critChance = 6, levelRequirement = 74, manaCost = 28, statInterpolation = { }, },
		[23] = { 1000, 820, 1230, 2, 0, 1, 1, critChance = 6, levelRequirement = 76, manaCost = 29, statInterpolation = { }, },
		[24] = { 1000, 917, 1375, 2, 0, 1, 1, critChance = 6, levelRequirement = 78, manaCost = 29, statInterpolation = { }, },
		[25] = { 1000, 1024, 1536, 2, 0, 1, 1, critChance = 6, levelRequirement = 80, manaCost = 30, statInterpolation = { }, },
		[26] = { 1000, 1143, 1714, 2, 0, 1, 1, critChance = 6, levelRequirement = 82, manaCost = 30, statInterpolation = { }, },
		[27] = { 1000, 1275, 1913, 2, 0, 1, 1, critChance = 6, levelRequirement = 84, manaCost = 30, statInterpolation = { }, },
		[28] = { 1000, 1422, 2134, 2, 0, 1, 1, critChance = 6, levelRequirement = 86, manaCost = 30, statInterpolation = { }, },
		[29] = { 1000, 1586, 2379, 2, 0, 1, 1, critChance = 6, levelRequirement = 88, manaCost = 31, statInterpolation = { }, },
		[30] = { 1000, 1767, 2651, 2, 0, 1, 1, critChance = 6, levelRequirement = 90, manaCost = 31, statInterpolation = { }, },
	},
}
skills["FireTrap"] = {
	name = "Fire Trap",
	color = 2,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies and leaving an area of burning ground that damages enemies who walk through it.",
	skillTypes = { [2] = true, [12] = true, [10] = true, [19] = true, [11] = true, [29] = true, [37] = true, [40] = true, [33] = true, },
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		{ "burn_damage_+%", 1.5 },
	},
	stats = {
		"is_trap",
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"active_skill_base_radius_+",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 1, 16000, 8000, 2, 4, 217, 0, critChance = 6, cooldown = 3, levelRequirement = 1, manaCost = 7, statInterpolation = { }, },
		[2] = { 1, 16000, 8000, 3, 5, 246, 0, critChance = 6, cooldown = 3, levelRequirement = 2, manaCost = 8, statInterpolation = { }, },
		[3] = { 1, 16000, 8000, 4, 6, 312, 1, critChance = 6, cooldown = 3, levelRequirement = 4, manaCost = 9, statInterpolation = { }, },
		[4] = { 1, 16000, 8000, 6, 8, 431, 1, critChance = 6, cooldown = 3, levelRequirement = 7, manaCost = 10, statInterpolation = { }, },
		[5] = { 1, 16000, 8000, 8, 12, 636, 1, critChance = 6, cooldown = 3, levelRequirement = 11, manaCost = 11, statInterpolation = { }, },
		[6] = { 1, 16000, 8000, 13, 19, 985, 2, critChance = 6, cooldown = 3, levelRequirement = 16, manaCost = 12, statInterpolation = { }, },
		[7] = { 1, 16000, 8000, 18, 27, 1354, 2, critChance = 6, cooldown = 3, levelRequirement = 20, manaCost = 13, statInterpolation = { }, },
		[8] = { 1, 16000, 8000, 25, 37, 1828, 2, critChance = 6, cooldown = 3, levelRequirement = 24, manaCost = 14, statInterpolation = { }, },
		[9] = { 1, 16000, 8000, 34, 50, 2432, 3, critChance = 6, cooldown = 3, levelRequirement = 28, manaCost = 14, statInterpolation = { }, },
		[10] = { 1, 16000, 8000, 45, 67, 3200, 3, critChance = 6, cooldown = 3, levelRequirement = 32, manaCost = 16, statInterpolation = { }, },
		[11] = { 1, 16000, 8000, 59, 89, 4170, 3, critChance = 6, cooldown = 3, levelRequirement = 36, manaCost = 17, statInterpolation = { }, },
		[12] = { 1, 16000, 8000, 78, 117, 5392, 4, critChance = 6, cooldown = 3, levelRequirement = 40, manaCost = 18, statInterpolation = { }, },
		[13] = { 1, 16000, 8000, 101, 152, 6925, 4, critChance = 6, cooldown = 3, levelRequirement = 44, manaCost = 19, statInterpolation = { }, },
		[14] = { 1, 16000, 8000, 132, 197, 8842, 4, critChance = 6, cooldown = 3, levelRequirement = 48, manaCost = 20, statInterpolation = { }, },
		[15] = { 1, 16000, 8000, 170, 255, 11233, 5, critChance = 6, cooldown = 3, levelRequirement = 52, manaCost = 21, statInterpolation = { }, },
		[16] = { 1, 16000, 8000, 219, 328, 14207, 5, critChance = 6, cooldown = 3, levelRequirement = 56, manaCost = 22, statInterpolation = { }, },
		[17] = { 1, 16000, 8000, 280, 420, 17897, 5, critChance = 6, cooldown = 3, levelRequirement = 60, manaCost = 22, statInterpolation = { }, },
		[18] = { 1, 16000, 8000, 358, 536, 22465, 6, critChance = 6, cooldown = 3, levelRequirement = 64, manaCost = 23, statInterpolation = { }, },
		[19] = { 1, 16000, 8000, 429, 643, 26467, 6, critChance = 6, cooldown = 3, levelRequirement = 67, manaCost = 24, statInterpolation = { }, },
		[20] = { 1, 16000, 8000, 513, 770, 31126, 6, critChance = 6, cooldown = 3, levelRequirement = 70, manaCost = 24, statInterpolation = { }, },
		[21] = { 1, 16000, 8000, 578, 867, 34437, 7, critChance = 6, cooldown = 3, levelRequirement = 72, manaCost = 25, statInterpolation = { }, },
		[22] = { 1, 16000, 8000, 651, 976, 38064, 7, critChance = 6, cooldown = 3, levelRequirement = 74, manaCost = 26, statInterpolation = { }, },
		[23] = { 1, 16000, 8000, 732, 1098, 42036, 7, critChance = 6, cooldown = 3, levelRequirement = 76, manaCost = 26, statInterpolation = { }, },
		[24] = { 1, 16000, 8000, 823, 1235, 46379, 8, critChance = 6, cooldown = 3, levelRequirement = 78, manaCost = 27, statInterpolation = { }, },
		[25] = { 1, 16000, 8000, 925, 1388, 51126, 8, critChance = 6, cooldown = 3, levelRequirement = 80, manaCost = 27, statInterpolation = { }, },
		[26] = { 1, 16000, 8000, 1040, 1559, 56310, 8, critChance = 6, cooldown = 3, levelRequirement = 82, manaCost = 28, statInterpolation = { }, },
		[27] = { 1, 16000, 8000, 1167, 1751, 61965, 9, critChance = 6, cooldown = 3, levelRequirement = 84, manaCost = 29, statInterpolation = { }, },
		[28] = { 1, 16000, 8000, 1310, 1965, 68128, 9, critChance = 6, cooldown = 3, levelRequirement = 86, manaCost = 30, statInterpolation = { }, },
		[29] = { 1, 16000, 8000, 1470, 2205, 74839, 9, critChance = 6, cooldown = 3, levelRequirement = 88, manaCost = 30, statInterpolation = { }, },
		[30] = { 1, 16000, 8000, 1648, 2472, 82139, 10, critChance = 6, cooldown = 3, levelRequirement = 90, manaCost = 30, statInterpolation = { }, },
	},
}
skills["FlickerStrike"] = {
	name = "Flicker Strike",
	color = 2,
	description = "Teleports the character to a nearby monster and attacks it with a melee weapon. If no specific monster is chosen, one is picked at random. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [1] = true, [6] = true, [24] = true, [25] = true, [28] = true, [38] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	statMap = {
		["flicker_strike_more_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack),
		},
		["base_skill_show_average_damage_instead_of_dps"] = {
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
	},
	stats = {
		"flicker_strike_more_attack_speed_+%_final",
		"base_attack_speed_+%_per_frenzy_charge",
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 20, 10, cooldown = 2, damageMultiplier = 30, levelRequirement = 10, manaCost = 10, statInterpolation = { }, },
		[2] = { 20, 10, cooldown = 2, damageMultiplier = 31.6, levelRequirement = 13, manaCost = 10, statInterpolation = { }, },
		[3] = { 20, 10, cooldown = 2, damageMultiplier = 33.2, levelRequirement = 17, manaCost = 10, statInterpolation = { }, },
		[4] = { 20, 10, cooldown = 2, damageMultiplier = 34.8, levelRequirement = 21, manaCost = 10, statInterpolation = { }, },
		[5] = { 20, 10, cooldown = 2, damageMultiplier = 36.4, levelRequirement = 25, manaCost = 10, statInterpolation = { }, },
		[6] = { 20, 10, cooldown = 2, damageMultiplier = 38, levelRequirement = 29, manaCost = 10, statInterpolation = { }, },
		[7] = { 20, 10, cooldown = 2, damageMultiplier = 39.6, levelRequirement = 33, manaCost = 10, statInterpolation = { }, },
		[8] = { 20, 10, cooldown = 2, damageMultiplier = 41.2, levelRequirement = 36, manaCost = 10, statInterpolation = { }, },
		[9] = { 20, 10, cooldown = 2, damageMultiplier = 42.8, levelRequirement = 39, manaCost = 10, statInterpolation = { }, },
		[10] = { 20, 10, cooldown = 2, damageMultiplier = 44.4, levelRequirement = 42, manaCost = 10, statInterpolation = { }, },
		[11] = { 20, 10, cooldown = 2, damageMultiplier = 46, levelRequirement = 45, manaCost = 10, statInterpolation = { }, },
		[12] = { 20, 10, cooldown = 2, damageMultiplier = 47.6, levelRequirement = 48, manaCost = 10, statInterpolation = { }, },
		[13] = { 20, 10, cooldown = 2, damageMultiplier = 49.2, levelRequirement = 51, manaCost = 10, statInterpolation = { }, },
		[14] = { 20, 10, cooldown = 2, damageMultiplier = 50.8, levelRequirement = 54, manaCost = 10, statInterpolation = { }, },
		[15] = { 20, 10, cooldown = 2, damageMultiplier = 52.4, levelRequirement = 57, manaCost = 10, statInterpolation = { }, },
		[16] = { 20, 10, cooldown = 2, damageMultiplier = 54, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[17] = { 20, 10, cooldown = 2, damageMultiplier = 55.6, levelRequirement = 63, manaCost = 10, statInterpolation = { }, },
		[18] = { 20, 10, cooldown = 2, damageMultiplier = 57.2, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 20, 10, cooldown = 2, damageMultiplier = 58.8, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 20, 10, cooldown = 2, damageMultiplier = 60.4, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 20, 10, cooldown = 2, damageMultiplier = 62, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 20, 10, cooldown = 2, damageMultiplier = 63.6, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 20, 10, cooldown = 2, damageMultiplier = 65.2, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { 20, 10, cooldown = 2, damageMultiplier = 66.8, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { 20, 10, cooldown = 2, damageMultiplier = 68.4, levelRequirement = 80, manaCost = 10, statInterpolation = { }, },
		[26] = { 20, 10, cooldown = 2, damageMultiplier = 70, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { 20, 10, cooldown = 2, damageMultiplier = 71.6, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { 20, 10, cooldown = 2, damageMultiplier = 73.2, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { 20, 10, cooldown = 2, damageMultiplier = 74.8, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { 20, 10, cooldown = 2, damageMultiplier = 76.4, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["FreezeMine"] = {
	name = "Freeze Mine",
	color = 2,
	description = "Lays a remote mine that you can detonate to freeze all enemies in the area.",
	skillTypes = { [2] = true, [10] = true, [11] = true, [12] = true, [41] = true, [34] = true, },
	castTime = 0.5,
	baseFlags = {
		spell = true,
		mine = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"freeze_mine_cold_resistance_+_while_frozen",
		"base_mine_duration",
		"freeze_as_though_dealt_damage_+%",
		"base_skill_is_mined",
		"base_skill_show_average_damage_instead_of_dps",
		"is_remote_mine",
		"always_freeze",
		"is_area_damage",
	},
	levels = {
		[1] = { 7, 10, -15, 16000, 200, damageEffectiveness = 0.5, levelRequirement = 10, manaCost = 6, statInterpolation = { }, },
		[2] = { 9, 13, -15, 16000, 210, damageEffectiveness = 0.5, levelRequirement = 13, manaCost = 8, statInterpolation = { }, },
		[3] = { 12, 17, -15, 16000, 220, damageEffectiveness = 0.5, levelRequirement = 17, manaCost = 10, statInterpolation = { }, },
		[4] = { 15, 23, -15, 16000, 230, damageEffectiveness = 0.5, levelRequirement = 21, manaCost = 10, statInterpolation = { }, },
		[5] = { 19, 29, -15, 16000, 240, damageEffectiveness = 0.5, levelRequirement = 25, manaCost = 11, statInterpolation = { }, },
		[6] = { 24, 37, -15, 16000, 250, damageEffectiveness = 0.5, levelRequirement = 29, manaCost = 12, statInterpolation = { }, },
		[7] = { 30, 46, -15, 16000, 260, damageEffectiveness = 0.5, levelRequirement = 33, manaCost = 13, statInterpolation = { }, },
		[8] = { 36, 54, -15, 16000, 270, damageEffectiveness = 0.5, levelRequirement = 36, manaCost = 14, statInterpolation = { }, },
		[9] = { 42, 63, -15, 16000, 280, damageEffectiveness = 0.5, levelRequirement = 39, manaCost = 14, statInterpolation = { }, },
		[10] = { 49, 73, -15, 16000, 290, damageEffectiveness = 0.5, levelRequirement = 42, manaCost = 16, statInterpolation = { }, },
		[11] = { 57, 85, -15, 16000, 300, damageEffectiveness = 0.5, levelRequirement = 45, manaCost = 18, statInterpolation = { }, },
		[12] = { 66, 99, -15, 16000, 310, damageEffectiveness = 0.5, levelRequirement = 48, manaCost = 18, statInterpolation = { }, },
		[13] = { 76, 114, -15, 16000, 320, damageEffectiveness = 0.5, levelRequirement = 51, manaCost = 19, statInterpolation = { }, },
		[14] = { 88, 131, -15, 16000, 330, damageEffectiveness = 0.5, levelRequirement = 54, manaCost = 20, statInterpolation = { }, },
		[15] = { 101, 151, -15, 16000, 340, damageEffectiveness = 0.5, levelRequirement = 57, manaCost = 21, statInterpolation = { }, },
		[16] = { 116, 173, -15, 16000, 350, damageEffectiveness = 0.5, levelRequirement = 60, manaCost = 21, statInterpolation = { }, },
		[17] = { 132, 199, -15, 16000, 360, damageEffectiveness = 0.5, levelRequirement = 63, manaCost = 21, statInterpolation = { }, },
		[18] = { 151, 227, -15, 16000, 370, damageEffectiveness = 0.5, levelRequirement = 66, manaCost = 21, statInterpolation = { }, },
		[19] = { 165, 248, -15, 16000, 380, damageEffectiveness = 0.5, levelRequirement = 68, manaCost = 22, statInterpolation = { }, },
		[20] = { 181, 271, -15, 16000, 390, damageEffectiveness = 0.5, levelRequirement = 70, manaCost = 22, statInterpolation = { }, },
		[21] = { 197, 296, -15, 16000, 400, damageEffectiveness = 0.5, levelRequirement = 72, manaCost = 22, statInterpolation = { }, },
		[22] = { 215, 322, -15, 16000, 410, damageEffectiveness = 0.5, levelRequirement = 74, manaCost = 22, statInterpolation = { }, },
		[23] = { 234, 351, -15, 16000, 420, damageEffectiveness = 0.5, levelRequirement = 76, manaCost = 23, statInterpolation = { }, },
		[24] = { 255, 383, -15, 16000, 430, damageEffectiveness = 0.5, levelRequirement = 78, manaCost = 23, statInterpolation = { }, },
		[25] = { 278, 417, -15, 16000, 440, damageEffectiveness = 0.5, levelRequirement = 80, manaCost = 24, statInterpolation = { }, },
		[26] = { 302, 454, -15, 16000, 450, damageEffectiveness = 0.5, levelRequirement = 82, manaCost = 24, statInterpolation = { }, },
		[27] = { 329, 493, -15, 16000, 460, damageEffectiveness = 0.5, levelRequirement = 84, manaCost = 24, statInterpolation = { }, },
		[28] = { 358, 536, -15, 16000, 470, damageEffectiveness = 0.5, levelRequirement = 86, manaCost = 24, statInterpolation = { }, },
		[29] = { 389, 583, -15, 16000, 480, damageEffectiveness = 0.5, levelRequirement = 88, manaCost = 25, statInterpolation = { }, },
		[30] = { 422, 633, -15, 16000, 490, damageEffectiveness = 0.5, levelRequirement = 90, manaCost = 25, statInterpolation = { }, },
	},
}
skills["Frenzy"] = {
	name = "Frenzy",
	color = 2,
	description = "Performs an attack that gives the character a frenzy charge if it hits. Frenzy charges increase your attack speed.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [6] = true, [22] = true, [17] = true, [19] = true, [25] = true, [28] = true, [24] = true, },
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"physical_damage_+%_per_frenzy_charge",
		"base_attack_speed_+%_per_frenzy_charge",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 5, 5, damageMultiplier = 10, levelRequirement = 16, manaCost = 10, statInterpolation = { }, },
		[2] = { 5, 5, damageMultiplier = 11.4, levelRequirement = 20, manaCost = 10, statInterpolation = { }, },
		[3] = { 5, 5, damageMultiplier = 12.8, levelRequirement = 24, manaCost = 10, statInterpolation = { }, },
		[4] = { 5, 5, damageMultiplier = 14.2, levelRequirement = 28, manaCost = 10, statInterpolation = { }, },
		[5] = { 5, 5, damageMultiplier = 15.6, levelRequirement = 31, manaCost = 10, statInterpolation = { }, },
		[6] = { 5, 5, damageMultiplier = 17, levelRequirement = 34, manaCost = 10, statInterpolation = { }, },
		[7] = { 5, 5, damageMultiplier = 18.4, levelRequirement = 37, manaCost = 10, statInterpolation = { }, },
		[8] = { 5, 5, damageMultiplier = 19.8, levelRequirement = 40, manaCost = 10, statInterpolation = { }, },
		[9] = { 5, 5, damageMultiplier = 21.2, levelRequirement = 43, manaCost = 10, statInterpolation = { }, },
		[10] = { 5, 5, damageMultiplier = 22.6, levelRequirement = 46, manaCost = 10, statInterpolation = { }, },
		[11] = { 5, 5, damageMultiplier = 24, levelRequirement = 49, manaCost = 10, statInterpolation = { }, },
		[12] = { 5, 5, damageMultiplier = 25.4, levelRequirement = 52, manaCost = 10, statInterpolation = { }, },
		[13] = { 5, 5, damageMultiplier = 26.8, levelRequirement = 55, manaCost = 10, statInterpolation = { }, },
		[14] = { 5, 5, damageMultiplier = 28.2, levelRequirement = 58, manaCost = 10, statInterpolation = { }, },
		[15] = { 5, 5, damageMultiplier = 29.6, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[16] = { 5, 5, damageMultiplier = 31, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 5, 5, damageMultiplier = 32.4, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 5, 5, damageMultiplier = 33.8, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 5, 5, damageMultiplier = 35.2, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 5, 5, damageMultiplier = 36.6, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 5, 5, damageMultiplier = 38, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 5, 5, damageMultiplier = 39.4, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 5, 5, damageMultiplier = 40.8, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { 5, 5, damageMultiplier = 42.2, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { 5, 5, damageMultiplier = 43.6, levelRequirement = 80, manaCost = 10, statInterpolation = { }, },
		[26] = { 5, 5, damageMultiplier = 45, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { 5, 5, damageMultiplier = 46.4, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { 5, 5, damageMultiplier = 47.8, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { 5, 5, damageMultiplier = 49.2, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { 5, 5, damageMultiplier = 50.6, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["FrostBlades"] = {
	name = "Frost Blades",
	color = 2,
	description = "Attack with increased range, releasing icy blades from the struck enemy that fly at other enemies. Requires a Melee Weapon.",
	skillTypes = { [1] = true, [3] = true, [6] = true, [25] = true, [28] = true, [24] = true, [34] = true, [48] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Icy blades",
			melee = false,
			projectile = true,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "projectile_damage_+%", 1 },
	},
	stats = {
		"number_of_additional_projectiles",
		"melee_weapon_range_+",
		"base_physical_damage_%_to_convert_to_cold",
		"total_projectile_spread_angle_override",
		"base_projectile_speed_+%",
		"show_number_of_projectiles",
	},
	levels = {
		[1] = { 4, 18, 60, 110, 0, manaCost = 6, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 4, 18, 60, 110, 1, damageMultiplier = 2.2, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 4, 18, 60, 110, 2, damageMultiplier = 4.4, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 4, 18, 60, 110, 3, damageMultiplier = 6.6, levelRequirement = 7, manaCost = 6, statInterpolation = { }, },
		[5] = { 4, 18, 60, 110, 4, damageMultiplier = 8.8, levelRequirement = 11, manaCost = 6, statInterpolation = { }, },
		[6] = { 5, 19, 60, 110, 5, damageMultiplier = 11, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { 5, 19, 60, 110, 6, damageMultiplier = 13.2, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { 5, 19, 60, 110, 7, damageMultiplier = 15.4, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { 5, 19, 60, 110, 8, damageMultiplier = 17.6, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { 5, 19, 60, 110, 9, damageMultiplier = 19.8, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { 6, 20, 60, 110, 10, damageMultiplier = 22, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[12] = { 6, 20, 60, 110, 11, damageMultiplier = 24.2, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[13] = { 6, 20, 60, 110, 12, damageMultiplier = 26.4, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[14] = { 6, 20, 60, 110, 13, damageMultiplier = 28.6, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[15] = { 6, 20, 60, 110, 14, damageMultiplier = 30.8, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[16] = { 7, 21, 60, 110, 15, damageMultiplier = 33, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[17] = { 7, 21, 60, 110, 16, damageMultiplier = 35.2, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[18] = { 7, 21, 60, 110, 17, damageMultiplier = 37.4, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 7, 21, 60, 110, 18, damageMultiplier = 39.6, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 7, 21, 60, 110, 19, damageMultiplier = 41.8, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 8, 22, 60, 110, 20, damageMultiplier = 44, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 8, 22, 60, 110, 21, damageMultiplier = 46.2, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 8, 22, 60, 110, 22, damageMultiplier = 48.4, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 8, 22, 60, 110, 23, damageMultiplier = 50.6, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 8, 22, 60, 110, 24, damageMultiplier = 52.8, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 9, 23, 60, 110, 25, damageMultiplier = 55, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 9, 23, 60, 110, 26, damageMultiplier = 57.2, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 9, 23, 60, 110, 27, damageMultiplier = 59.4, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 9, 23, 60, 110, 28, damageMultiplier = 61.6, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 9, 23, 60, 110, 29, damageMultiplier = 63.8, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["Grace"] = {
	name = "Grace",
	color = 2,
	description = "Casts an aura that grants evasion to you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, },
	castTime = 1.2,
	statMap = {
		["base_evasion_rating"] = {
			mod("Evasion", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"base_evasion_rating",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 227, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { }, },
		[2] = { 271, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { }, },
		[3] = { 322, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { }, },
		[4] = { 379, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { }, },
		[5] = { 444, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { }, },
		[6] = { 528, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { }, },
		[7] = { 621, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { }, },
		[8] = { 722, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { }, },
		[9] = { 845, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { }, },
		[10] = { 940, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { }, },
		[11] = { 1043, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { }, },
		[12] = { 1155, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { }, },
		[13] = { 1283, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { }, },
		[14] = { 1413, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[15] = { 1567, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[16] = { 1732, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { }, },
		[17] = { 1914, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { }, },
		[18] = { 2115, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { }, },
		[19] = { 2335, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { }, },
		[20] = { 2575, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { }, },
		[21] = { 2700, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { }, },
		[22] = { 2835, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { }, },
		[23] = { 2979, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { }, },
		[24] = { 3124, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { }, },
		[25] = { 3279, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { }, },
		[26] = { 3444, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { }, },
		[27] = { 3611, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { }, },
		[28] = { 3795, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 3982, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { }, },
		[30] = { 4179, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { }, },
	},
}
skills["VaalGrace"] = {
	name = "Vaal Grace",
	color = 2,
	description = "Casts a temporary aura that grants you and your allies the ability to dodge attacks and spells.",
	skillTypes = { [2] = true, [5] = true, [11] = true, [18] = true, [27] = true, [12] = true, [43] = true, [44] = true, },
	castTime = 0.6,
	statMap = {
		["base_chance_to_dodge_%"] = {
			mod("AttackDodgeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_chance_to_dodge_spells_%"] = {
			mod("SpellDodgeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"base_chance_to_dodge_%",
		"base_chance_to_dodge_spells_%",
		"base_skill_area_of_effect_+%",
		"base_skill_effect_duration",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 24, 24, 0, 6000, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 25, 25, 3, 6000, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 25, 25, 6, 6000, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 26, 26, 9, 6000, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 26, 26, 12, 6000, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 27, 27, 15, 6000, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 27, 27, 18, 6000, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 28, 28, 21, 6000, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 28, 28, 23, 6000, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 29, 29, 25, 6000, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 29, 29, 27, 6000, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 30, 30, 29, 6000, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 30, 30, 31, 6000, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 31, 31, 33, 6000, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 31, 31, 35, 6000, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 32, 32, 36, 6000, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 32, 32, 37, 6000, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 33, 33, 38, 6000, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 33, 33, 39, 6000, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 34, 34, 40, 6000, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 34, 34, 41, 6000, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 35, 35, 42, 6000, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 35, 35, 43, 6000, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 36, 36, 44, 6000, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 36, 36, 45, 6000, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 37, 37, 46, 6000, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 37, 37, 47, 6000, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 38, 38, 48, 6000, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 38, 38, 49, 6000, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 39, 39, 50, 6000, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Haste"] = {
	name = "Haste",
	color = 2,
	description = "Casts an aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, },
	castTime = 1.2,
	statMap = {
		["cast_speed_+%_from_haste_aura"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"attack_speed_+%",
		"cast_speed_+%_from_haste_aura",
		"base_movement_velocity_+%",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 9, 9, 4, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { }, },
		[2] = { 10, 9, 4, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { }, },
		[3] = { 10, 10, 4, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { }, },
		[4] = { 10, 10, 5, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { }, },
		[5] = { 11, 10, 5, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { }, },
		[6] = { 11, 11, 5, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { }, },
		[7] = { 11, 11, 6, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { }, },
		[8] = { 12, 11, 6, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { }, },
		[9] = { 12, 12, 6, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { }, },
		[10] = { 12, 12, 7, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { }, },
		[11] = { 13, 12, 7, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { }, },
		[12] = { 13, 13, 7, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { }, },
		[13] = { 13, 13, 8, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { }, },
		[14] = { 14, 13, 8, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[15] = { 14, 14, 8, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[16] = { 15, 14, 8, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { }, },
		[17] = { 15, 15, 8, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { }, },
		[18] = { 16, 15, 8, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { }, },
		[19] = { 16, 16, 8, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { }, },
		[20] = { 16, 16, 9, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { }, },
		[21] = { 17, 16, 9, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { }, },
		[22] = { 17, 17, 9, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { }, },
		[23] = { 17, 17, 10, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { }, },
		[24] = { 18, 17, 10, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { }, },
		[25] = { 18, 18, 10, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { }, },
		[26] = { 18, 18, 11, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { }, },
		[27] = { 19, 18, 11, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { }, },
		[28] = { 19, 19, 11, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 19, 19, 12, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { }, },
		[30] = { 20, 19, 12, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { }, },
	},
}
skills["VaalHaste"] = {
	name = "Vaal Haste",
	color = 2,
	description = "Casts a temporary aura that increases the movement speed, attack speed and cast speed of you and your allies.",
	skillTypes = { [2] = true, [5] = true, [11] = true, [18] = true, [27] = true, [12] = true, [43] = true, [44] = true, },
	castTime = 0.6,
	statMap = {
		["cast_speed_+%_from_haste_aura"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"attack_speed_+%",
		"cast_speed_+%_from_haste_aura",
		"base_movement_velocity_+%",
		"base_skill_area_of_effect_+%",
		"base_skill_effect_duration",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 25, 24, 10, 0, 4000, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 25, 25, 10, 3, 4000, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 25, 25, 10, 6, 4000, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 26, 25, 10, 9, 4000, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 26, 26, 10, 12, 4000, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 26, 26, 11, 15, 4000, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 27, 26, 11, 18, 4000, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 27, 27, 11, 21, 4000, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 27, 27, 11, 23, 4000, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 28, 27, 11, 25, 4000, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 28, 28, 12, 27, 4000, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 28, 28, 12, 29, 4000, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 29, 28, 12, 31, 4000, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 29, 29, 12, 33, 4000, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 29, 29, 12, 35, 4000, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 30, 29, 13, 36, 4000, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 30, 30, 13, 37, 4000, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 30, 30, 13, 38, 4000, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 31, 30, 13, 39, 4000, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 31, 31, 13, 40, 4000, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 31, 31, 14, 41, 4000, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 32, 31, 14, 42, 4000, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 32, 32, 14, 43, 4000, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 32, 32, 14, 44, 4000, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 33, 32, 14, 45, 4000, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 33, 33, 15, 46, 4000, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 33, 33, 15, 47, 4000, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 34, 33, 15, 48, 4000, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 34, 34, 15, 49, 4000, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 34, 34, 15, 50, 4000, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Hatred"] = {
	name = "Hatred",
	color = 2,
	description = "Casts an aura that increases the cold damage of you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, [34] = true, },
	castTime = 1.2,
	statMap = {
		["physical_damage_%_to_add_as_cold"] = {
			mod("PhysicalDamageGainAsCold", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"physical_damage_%_to_add_as_cold",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 26, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { }, },
		[2] = { 26, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { }, },
		[3] = { 27, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { }, },
		[4] = { 27, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { }, },
		[5] = { 28, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { }, },
		[6] = { 28, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { }, },
		[7] = { 29, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { }, },
		[8] = { 29, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { }, },
		[9] = { 30, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { }, },
		[10] = { 30, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { }, },
		[11] = { 31, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { }, },
		[12] = { 31, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { }, },
		[13] = { 32, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { }, },
		[14] = { 32, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[15] = { 33, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[16] = { 34, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { }, },
		[17] = { 34, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { }, },
		[18] = { 35, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { }, },
		[19] = { 35, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { }, },
		[20] = { 36, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { }, },
		[21] = { 36, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { }, },
		[22] = { 37, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { }, },
		[23] = { 37, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { }, },
		[24] = { 38, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { }, },
		[25] = { 38, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { }, },
		[26] = { 39, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { }, },
		[27] = { 39, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { }, },
		[28] = { 40, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 40, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { }, },
		[30] = { 41, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { }, },
	},
}
skills["HeraldOfIce"] = {
	name = "Herald of Ice",
	color = 2,
	description = "Channel ice through your hands, adding cold damage to spells and attacks. If you shatter an enemy, they explode and deal AoE cold damage to enemies near them.",
	skillTypes = { [39] = true, [5] = true, [15] = true, [16] = true, [10] = true, [11] = true, [34] = true, [27] = true, },
	castTime = 1,
	statMap = {
		["herald_of_ice_cold_damage_+%"] = {
			mod("ColdDamage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["spell_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["spell_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_minimum_added_cold_damage"] = {
			mod("ColdMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["attack_maximum_added_cold_damage"] = {
			mod("ColdMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "herald_of_ice_cold_damage_+%", 0.75 },
	},
	stats = {
		"spell_minimum_added_cold_damage",
		"spell_maximum_added_cold_damage",
		"attack_minimum_added_cold_damage",
		"attack_maximum_added_cold_damage",
		"secondary_minimum_base_cold_damage",
		"secondary_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"damage_cannot_be_reflected",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 4, 5, 4, 5, 18, 26, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 16, manaCost = 25, statInterpolation = { }, },
		[2] = { 5, 7, 5, 7, 23, 35, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 20, manaCost = 25, statInterpolation = { }, },
		[3] = { 6, 8, 6, 8, 30, 45, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 24, manaCost = 25, statInterpolation = { }, },
		[4] = { 7, 10, 7, 10, 38, 57, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 28, manaCost = 25, statInterpolation = { }, },
		[5] = { 8, 12, 8, 12, 45, 67, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 31, manaCost = 25, statInterpolation = { }, },
		[6] = { 9, 14, 9, 14, 53, 80, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 34, manaCost = 25, statInterpolation = { }, },
		[7] = { 10, 16, 10, 16, 62, 94, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 37, manaCost = 25, statInterpolation = { }, },
		[8] = { 12, 18, 12, 18, 73, 110, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 40, manaCost = 25, statInterpolation = { }, },
		[9] = { 13, 20, 13, 20, 85, 128, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 43, manaCost = 25, statInterpolation = { }, },
		[10] = { 15, 23, 15, 23, 99, 149, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 46, manaCost = 25, statInterpolation = { }, },
		[11] = { 17, 26, 17, 26, 115, 173, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 49, manaCost = 25, statInterpolation = { }, },
		[12] = { 19, 29, 19, 29, 134, 200, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 52, manaCost = 25, statInterpolation = { }, },
		[13] = { 22, 33, 22, 33, 154, 232, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 55, manaCost = 25, statInterpolation = { }, },
		[14] = { 24, 37, 24, 37, 178, 267, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 58, manaCost = 25, statInterpolation = { }, },
		[15] = { 26, 39, 26, 39, 195, 293, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 60, manaCost = 25, statInterpolation = { }, },
		[16] = { 28, 42, 28, 42, 214, 321, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 62, manaCost = 25, statInterpolation = { }, },
		[17] = { 30, 46, 30, 46, 235, 352, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 64, manaCost = 25, statInterpolation = { }, },
		[18] = { 33, 49, 33, 49, 257, 386, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 66, manaCost = 25, statInterpolation = { }, },
		[19] = { 35, 53, 35, 53, 282, 422, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 68, manaCost = 25, statInterpolation = { }, },
		[20] = { 38, 56, 38, 56, 308, 462, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 70, manaCost = 25, statInterpolation = { }, },
		[21] = { 40, 61, 40, 61, 337, 505, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 72, manaCost = 25, statInterpolation = { }, },
		[22] = { 43, 65, 43, 65, 368, 552, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 74, manaCost = 25, statInterpolation = { }, },
		[23] = { 46, 70, 46, 70, 402, 603, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 76, manaCost = 25, statInterpolation = { }, },
		[24] = { 50, 75, 50, 75, 438, 658, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 78, manaCost = 25, statInterpolation = { }, },
		[25] = { 53, 80, 53, 80, 478, 717, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 80, manaCost = 25, statInterpolation = { }, },
		[26] = { 57, 85, 57, 85, 521, 782, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 82, manaCost = 25, statInterpolation = { }, },
		[27] = { 61, 91, 61, 91, 568, 852, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 84, manaCost = 25, statInterpolation = { }, },
		[28] = { 65, 98, 65, 98, 619, 928, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 86, manaCost = 25, statInterpolation = { }, },
		[29] = { 69, 104, 69, 104, 674, 1010, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 88, manaCost = 25, statInterpolation = { }, },
		[30] = { 74, 111, 74, 111, 733, 1100, damageEffectiveness = 0.8, cooldown = 1, levelRequirement = 90, manaCost = 25, statInterpolation = { }, },
	},
}
skills["IceShot"] = {
	name = "Ice Shot",
	color = 2,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target. Creates a patch of ground ice under the target.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [11] = true, [12] = true, [22] = true, [17] = true, [19] = true, [34] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToCold", "BASE", 40, 0, 0, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 23),
	},
	qualityStats = {
		{ "cold_damage_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"base_skill_effect_duration",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 60, 1500, damageMultiplier = 20, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 60, 1500, damageMultiplier = 21.4, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 60, 1500, damageMultiplier = 22.8, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 60, 1500, damageMultiplier = 24.2, levelRequirement = 7, manaCost = 7, statInterpolation = { }, },
		[5] = { 60, 1500, damageMultiplier = 25.6, levelRequirement = 11, manaCost = 7, statInterpolation = { }, },
		[6] = { 60, 1500, damageMultiplier = 27, levelRequirement = 16, manaCost = 7, statInterpolation = { }, },
		[7] = { 60, 1500, damageMultiplier = 28.4, levelRequirement = 20, manaCost = 7, statInterpolation = { }, },
		[8] = { 60, 1500, damageMultiplier = 29.8, levelRequirement = 24, manaCost = 8, statInterpolation = { }, },
		[9] = { 60, 1500, damageMultiplier = 31.2, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[10] = { 60, 1500, damageMultiplier = 32.6, levelRequirement = 32, manaCost = 8, statInterpolation = { }, },
		[11] = { 60, 1500, damageMultiplier = 34, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[12] = { 60, 1500, damageMultiplier = 35.4, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[13] = { 60, 1500, damageMultiplier = 36.8, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[14] = { 60, 1500, damageMultiplier = 38.2, levelRequirement = 48, manaCost = 9, statInterpolation = { }, },
		[15] = { 60, 1500, damageMultiplier = 39.6, levelRequirement = 52, manaCost = 9, statInterpolation = { }, },
		[16] = { 60, 1500, damageMultiplier = 41, levelRequirement = 56, manaCost = 9, statInterpolation = { }, },
		[17] = { 60, 1500, damageMultiplier = 42.4, levelRequirement = 60, manaCost = 9, statInterpolation = { }, },
		[18] = { 60, 1500, damageMultiplier = 43.8, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[19] = { 60, 1500, damageMultiplier = 45.2, levelRequirement = 67, manaCost = 10, statInterpolation = { }, },
		[20] = { 60, 1500, damageMultiplier = 46.6, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 60, 1500, damageMultiplier = 48, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 60, 1500, damageMultiplier = 49.4, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 60, 1500, damageMultiplier = 50.8, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 60, 1500, damageMultiplier = 52.2, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 60, 1500, damageMultiplier = 53.6, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 60, 1500, damageMultiplier = 55, levelRequirement = 82, manaCost = 11, statInterpolation = { }, },
		[27] = { 60, 1500, damageMultiplier = 56.4, levelRequirement = 84, manaCost = 11, statInterpolation = { }, },
		[28] = { 60, 1500, damageMultiplier = 57.8, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 60, 1500, damageMultiplier = 59.2, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 60, 1500, damageMultiplier = 60.6, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["IceTrap"] = {
	name = "Ice Trap",
	color = 2,
	description = "Throws a trap that creates a series of icy runic explosions when triggered, dealing cold damage to all enemies caught in the blasts.",
	skillTypes = { [2] = true, [10] = true, [19] = true, [11] = true, [37] = true, [34] = true, [12] = true, },
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_trap_duration",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_skill_is_trapped",
		"base_skill_show_average_damage_instead_of_dps",
		"is_trap",
	},
	levels = {
		[1] = { 16000, 60, 90, critChance = 5, manaCost = 13, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 28, statInterpolation = { }, },
		[2] = { 16000, 72, 108, critChance = 5, manaCost = 14, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 31, statInterpolation = { }, },
		[3] = { 16000, 85, 128, critChance = 5, manaCost = 15, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 34, statInterpolation = { }, },
		[4] = { 16000, 101, 151, critChance = 5, manaCost = 15, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 37, statInterpolation = { }, },
		[5] = { 16000, 119, 178, critChance = 5, manaCost = 16, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 40, statInterpolation = { }, },
		[6] = { 16000, 132, 198, critChance = 5, manaCost = 17, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 42, statInterpolation = { }, },
		[7] = { 16000, 147, 220, critChance = 5, manaCost = 17, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 44, statInterpolation = { }, },
		[8] = { 16000, 163, 244, critChance = 5, manaCost = 18, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 46, statInterpolation = { }, },
		[9] = { 16000, 180, 270, critChance = 5, manaCost = 19, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 16000, 199, 299, critChance = 5, manaCost = 19, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 16000, 220, 330, critChance = 5, manaCost = 20, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 16000, 243, 364, critChance = 5, manaCost = 20, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 16000, 268, 402, critChance = 5, manaCost = 21, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 16000, 295, 442, critChance = 5, manaCost = 21, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 16000, 325, 487, critChance = 5, manaCost = 22, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 16000, 357, 536, critChance = 5, manaCost = 23, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 16000, 392, 589, critChance = 5, manaCost = 23, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 16000, 431, 646, critChance = 5, manaCost = 24, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 16000, 473, 709, critChance = 5, manaCost = 24, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 16000, 519, 778, critChance = 5, manaCost = 25, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 16000, 568, 853, critChance = 5, manaCost = 26, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 16000, 623, 934, critChance = 5, manaCost = 26, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 16000, 681, 1022, critChance = 5, manaCost = 27, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 16000, 746, 1118, critChance = 5, manaCost = 27, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 16000, 815, 1223, critChance = 5, manaCost = 28, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 16000, 891, 1337, critChance = 5, manaCost = 28, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 16000, 973, 1460, critChance = 5, manaCost = 29, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 16000, 1063, 1595, critChance = 5, manaCost = 30, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 16000, 1160, 1740, critChance = 5, manaCost = 30, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 16000, 1266, 1899, critChance = 5, manaCost = 31, damageEffectiveness = 1.1, cooldown = 2, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["DoubleSlash"] = {
	name = "Lacerate",
	color = 2,
	description = "Slashes twice, releasing waves of force that damage enemies they hit. Enemies in the middle of the slashes can be hit by both. If you are dual wielding, you attack with your Main Hand, then your Off Hand. Can be used with Axes and Swords.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "One slash",
		},
		{
			name = "Both slashes",
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 38),
		skill("dpsMultiplier", 2, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { -25, 0, damageMultiplier = -5, levelRequirement = 12, manaCost = 8, statInterpolation = { }, },
		[2] = { -25, 0, damageMultiplier = -3.8, levelRequirement = 15, manaCost = 8, statInterpolation = { }, },
		[3] = { -25, 0, damageMultiplier = -2.6, levelRequirement = 19, manaCost = 8, statInterpolation = { }, },
		[4] = { -25, 1, damageMultiplier = -1.4, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { -25, 1, damageMultiplier = -0.2, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { -25, 1, damageMultiplier = 1, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { -25, 1, damageMultiplier = 2.2, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { -25, 2, damageMultiplier = 3.4, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { -25, 2, damageMultiplier = 4.6, levelRequirement = 41, manaCost = 8, statInterpolation = { }, },
		[10] = { -25, 2, damageMultiplier = 5.8, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[11] = { -25, 2, damageMultiplier = 7, levelRequirement = 47, manaCost = 8, statInterpolation = { }, },
		[12] = { -25, 3, damageMultiplier = 8.2, levelRequirement = 50, manaCost = 8, statInterpolation = { }, },
		[13] = { -25, 3, damageMultiplier = 9.4, levelRequirement = 53, manaCost = 8, statInterpolation = { }, },
		[14] = { -25, 3, damageMultiplier = 10.6, levelRequirement = 56, manaCost = 8, statInterpolation = { }, },
		[15] = { -25, 3, damageMultiplier = 11.8, levelRequirement = 59, manaCost = 8, statInterpolation = { }, },
		[16] = { -25, 4, damageMultiplier = 13, levelRequirement = 62, manaCost = 8, statInterpolation = { }, },
		[17] = { -25, 4, damageMultiplier = 14.2, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[18] = { -25, 4, damageMultiplier = 15.4, levelRequirement = 66, manaCost = 8, statInterpolation = { }, },
		[19] = { -25, 4, damageMultiplier = 16.6, levelRequirement = 68, manaCost = 8, statInterpolation = { }, },
		[20] = { -25, 5, damageMultiplier = 17.8, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { -25, 5, damageMultiplier = 19, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { -25, 5, damageMultiplier = 20.2, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { -25, 5, damageMultiplier = 21.4, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { -25, 6, damageMultiplier = 22.6, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { -25, 6, damageMultiplier = 23.8, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { -25, 6, damageMultiplier = 25, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { -25, 6, damageMultiplier = 26.2, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { -25, 7, damageMultiplier = 27.4, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { -25, 7, damageMultiplier = 28.6, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { -25, 7, damageMultiplier = 29.8, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["LightningArrow"] = {
	name = "Lightning Arrow",
	color = 2,
	description = "Fires a charged arrow at the target, causing them to be struck by a bolt of lightning which damages nearby enemies.",
	skillTypes = { [1] = true, [48] = true, [11] = true, [3] = true, [22] = true, [17] = true, [19] = true, [35] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_chance_to_shock_%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"lightning_arrow_maximum_number_of_extra_targets",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 50, 3, manaCost = 7, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 50, 3, damageMultiplier = 1, levelRequirement = 15, manaCost = 7, statInterpolation = { }, },
		[3] = { 50, 3, damageMultiplier = 2, levelRequirement = 19, manaCost = 7, statInterpolation = { }, },
		[4] = { 50, 3, damageMultiplier = 3, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { 50, 3, damageMultiplier = 4, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { 50, 3, damageMultiplier = 5, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { 50, 3, damageMultiplier = 6, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { 50, 3, damageMultiplier = 7, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { 50, 3, damageMultiplier = 8, levelRequirement = 41, manaCost = 9, statInterpolation = { }, },
		[10] = { 50, 3, damageMultiplier = 9, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[11] = { 50, 3, damageMultiplier = 10, levelRequirement = 47, manaCost = 9, statInterpolation = { }, },
		[12] = { 50, 3, damageMultiplier = 11, levelRequirement = 50, manaCost = 9, statInterpolation = { }, },
		[13] = { 50, 3, damageMultiplier = 12, levelRequirement = 53, manaCost = 9, statInterpolation = { }, },
		[14] = { 50, 3, damageMultiplier = 13, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[15] = { 50, 3, damageMultiplier = 14, levelRequirement = 59, manaCost = 10, statInterpolation = { }, },
		[16] = { 50, 3, damageMultiplier = 15, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 50, 3, damageMultiplier = 16, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 50, 3, damageMultiplier = 17, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 50, 3, damageMultiplier = 18, levelRequirement = 68, manaCost = 11, statInterpolation = { }, },
		[20] = { 50, 3, damageMultiplier = 19, levelRequirement = 70, manaCost = 11, statInterpolation = { }, },
		[21] = { 50, 3, damageMultiplier = 20, levelRequirement = 72, manaCost = 11, statInterpolation = { }, },
		[22] = { 50, 3, damageMultiplier = 21, levelRequirement = 74, manaCost = 11, statInterpolation = { }, },
		[23] = { 50, 3, damageMultiplier = 22, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 50, 3, damageMultiplier = 23, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 50, 3, damageMultiplier = 24, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 50, 3, damageMultiplier = 25, levelRequirement = 82, manaCost = 12, statInterpolation = { }, },
		[27] = { 50, 3, damageMultiplier = 26, levelRequirement = 84, manaCost = 12, statInterpolation = { }, },
		[28] = { 50, 3, damageMultiplier = 27, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 50, 3, damageMultiplier = 28, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 50, 3, damageMultiplier = 29, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["LightningStrike"] = {
	name = "Lightning Strike",
	color = 2,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy is released from the weapon as projectiles as you strike, flying out behind your target to hit farther-away enemies. The projectiles cannot miss if the melee attack hit its target.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [6] = true, [25] = true, [28] = true, [24] = true, [35] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			melee = true,
			projectile = false,
		},
		{
			name = "Projectiles",
			melee = false,
			projectile = true,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "pierce_%", 2 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"number_of_additional_projectiles",
		"active_skill_projectile_damage_+%_final",
		"total_projectile_spread_angle_override",
		"show_number_of_projectiles",
	},
	levels = {
		[1] = { 50, 4, -25, 70, damageMultiplier = 30, levelRequirement = 12, manaCost = 6, statInterpolation = { }, },
		[2] = { 50, 4, -25, 70, damageMultiplier = 32.4, levelRequirement = 15, manaCost = 6, statInterpolation = { }, },
		[3] = { 50, 4, -25, 70, damageMultiplier = 34.8, levelRequirement = 19, manaCost = 6, statInterpolation = { }, },
		[4] = { 50, 4, -25, 70, damageMultiplier = 37.2, levelRequirement = 23, manaCost = 6, statInterpolation = { }, },
		[5] = { 50, 4, -25, 70, damageMultiplier = 39.6, levelRequirement = 27, manaCost = 6, statInterpolation = { }, },
		[6] = { 50, 5, -25, 70, damageMultiplier = 42, levelRequirement = 31, manaCost = 6, statInterpolation = { }, },
		[7] = { 50, 5, -25, 70, damageMultiplier = 44.4, levelRequirement = 35, manaCost = 6, statInterpolation = { }, },
		[8] = { 50, 5, -25, 70, damageMultiplier = 46.8, levelRequirement = 38, manaCost = 6, statInterpolation = { }, },
		[9] = { 50, 5, -25, 70, damageMultiplier = 49.2, levelRequirement = 41, manaCost = 6, statInterpolation = { }, },
		[10] = { 50, 5, -25, 70, damageMultiplier = 51.6, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[11] = { 50, 6, -25, 70, damageMultiplier = 54, levelRequirement = 47, manaCost = 6, statInterpolation = { }, },
		[12] = { 50, 6, -25, 70, damageMultiplier = 56.4, levelRequirement = 50, manaCost = 6, statInterpolation = { }, },
		[13] = { 50, 6, -25, 70, damageMultiplier = 58.8, levelRequirement = 53, manaCost = 6, statInterpolation = { }, },
		[14] = { 50, 6, -25, 70, damageMultiplier = 61.2, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[15] = { 50, 6, -25, 70, damageMultiplier = 63.6, levelRequirement = 59, manaCost = 6, statInterpolation = { }, },
		[16] = { 50, 7, -25, 70, damageMultiplier = 66, levelRequirement = 62, manaCost = 6, statInterpolation = { }, },
		[17] = { 50, 7, -25, 70, damageMultiplier = 68.4, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[18] = { 50, 7, -25, 70, damageMultiplier = 70.8, levelRequirement = 66, manaCost = 6, statInterpolation = { }, },
		[19] = { 50, 7, -25, 70, damageMultiplier = 73.2, levelRequirement = 68, manaCost = 6, statInterpolation = { }, },
		[20] = { 50, 7, -25, 70, damageMultiplier = 75.6, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 50, 8, -25, 70, damageMultiplier = 78, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 50, 8, -25, 70, damageMultiplier = 80.4, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 50, 8, -25, 70, damageMultiplier = 82.8, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 50, 8, -25, 70, damageMultiplier = 85.2, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 50, 8, -25, 70, damageMultiplier = 87.6, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 50, 9, -25, 70, damageMultiplier = 90, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 50, 9, -25, 70, damageMultiplier = 92.4, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 50, 9, -25, 70, damageMultiplier = 94.8, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 50, 9, -25, 70, damageMultiplier = 97.2, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 50, 9, -25, 70, damageMultiplier = 99.6, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["VaalLightningStrike"] = {
	name = "Vaal Lightning Strike",
	color = 2,
	description = "Infuses your melee weapon with electrical energies as you swing. In addition to converting some of your physical damage to lightning damage, the stored energy is forced into the enemy as you strike, electrically charging them for a duration, during which lightning will arc between them and other nearby enemies, dealing damage. This occurs even if the attack is dodged.",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, [12] = true, [43] = true, [35] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Strike",
		},
		{
			name = "Beams",
		},
	},
	statMap = {
		["vaal_lightning_strike_beam_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"base_skill_effect_duration",
		"vaal_lightning_strike_beam_damage_+%_final",
		"global_always_hit",
	},
	levels = {
		[1] = { 50, 5000, -50, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 50, 5200, -50, damageMultiplier = 1.2, levelRequirement = 15, statInterpolation = { }, },
		[3] = { 50, 5400, -50, damageMultiplier = 2.4, levelRequirement = 19, statInterpolation = { }, },
		[4] = { 50, 5600, -50, damageMultiplier = 3.6, levelRequirement = 23, statInterpolation = { }, },
		[5] = { 50, 5800, -50, damageMultiplier = 4.8, levelRequirement = 27, statInterpolation = { }, },
		[6] = { 50, 6000, -50, damageMultiplier = 6, levelRequirement = 31, statInterpolation = { }, },
		[7] = { 50, 6200, -50, damageMultiplier = 7.2, levelRequirement = 35, statInterpolation = { }, },
		[8] = { 50, 6400, -50, damageMultiplier = 8.4, levelRequirement = 38, statInterpolation = { }, },
		[9] = { 50, 6600, -50, damageMultiplier = 9.6, levelRequirement = 41, statInterpolation = { }, },
		[10] = { 50, 6800, -50, damageMultiplier = 10.8, levelRequirement = 44, statInterpolation = { }, },
		[11] = { 50, 7000, -50, damageMultiplier = 12, levelRequirement = 47, statInterpolation = { }, },
		[12] = { 50, 7200, -50, damageMultiplier = 13.2, levelRequirement = 50, statInterpolation = { }, },
		[13] = { 50, 7400, -50, damageMultiplier = 14.4, levelRequirement = 53, statInterpolation = { }, },
		[14] = { 50, 7600, -50, damageMultiplier = 15.6, levelRequirement = 56, statInterpolation = { }, },
		[15] = { 50, 7800, -50, damageMultiplier = 16.8, levelRequirement = 59, statInterpolation = { }, },
		[16] = { 50, 8000, -50, damageMultiplier = 18, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 50, 8200, -50, damageMultiplier = 19.2, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 50, 8400, -50, damageMultiplier = 20.4, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 50, 8600, -50, damageMultiplier = 21.6, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 50, 8800, -50, damageMultiplier = 22.8, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 50, 9000, -50, damageMultiplier = 24, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 50, 9200, -50, damageMultiplier = 25.2, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 50, 9400, -50, damageMultiplier = 26.4, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 50, 9600, -50, damageMultiplier = 27.6, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 50, 9800, -50, damageMultiplier = 28.8, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 50, 10000, -50, damageMultiplier = 30, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 50, 10200, -50, damageMultiplier = 31.2, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 50, 10400, -50, damageMultiplier = 32.4, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 50, 10600, -50, damageMultiplier = 33.6, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 50, 10800, -50, damageMultiplier = 34.8, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["MirrorArrow"] = {
	name = "Mirror Arrow",
	color = 2,
	description = "Fires an arrow at the target destination. When the arrow lands, a clone is summoned. The clone is a minion that uses your bow and quiver.",
	skillTypes = { [14] = true, [1] = true, [9] = true, [48] = true, [21] = true, [12] = true, [22] = true, [17] = true, [19] = true, },
	minionSkillTypes = { [1] = true, [3] = true, [48] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	minionList = {
		"Clone",
	},
	baseFlags = {
		attack = true,
		projectile = true,
		minion = true,
		duration = true,
	},
	baseMods = {
		skill("minionUseBowAndQuiver", true),
	},
	qualityStats = {
		{ "base_arrow_speed_+%", 1.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"minion_damage_+%",
		"minion_maximum_life_+%",
		"active_skill_minion_damage_+%_final",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"base_is_projectile",
	},
	levels = {
		[1] = { 3000, 1, 0, 0, 75, 4, 24, cooldown = 3, levelRequirement = 10, manaCost = 14, statInterpolation = { }, },
		[2] = { 3000, 1, 6, 3, 75, 4, 27, cooldown = 3, levelRequirement = 13, manaCost = 14, statInterpolation = { }, },
		[3] = { 3000, 1, 12, 6, 75, 4, 30, cooldown = 3, levelRequirement = 17, manaCost = 15, statInterpolation = { }, },
		[4] = { 3000, 1, 18, 9, 75, 4, 33, cooldown = 3, levelRequirement = 21, manaCost = 15, statInterpolation = { }, },
		[5] = { 3000, 1, 24, 12, 75, 4, 35, cooldown = 3, levelRequirement = 25, manaCost = 15, statInterpolation = { }, },
		[6] = { 3000, 1, 30, 15, 75, 4, 38, cooldown = 3, levelRequirement = 29, manaCost = 16, statInterpolation = { }, },
		[7] = { 3000, 1, 36, 18, 75, 4, 40, cooldown = 3, levelRequirement = 33, manaCost = 16, statInterpolation = { }, },
		[8] = { 3000, 1, 42, 21, 75, 4, 43, cooldown = 3, levelRequirement = 36, manaCost = 16, statInterpolation = { }, },
		[9] = { 3000, 1, 48, 24, 75, 4, 46, cooldown = 3, levelRequirement = 39, manaCost = 16, statInterpolation = { }, },
		[10] = { 3000, 1, 54, 27, 75, 4, 48, cooldown = 3, levelRequirement = 42, manaCost = 17, statInterpolation = { }, },
		[11] = { 3000, 1, 60, 30, 75, 4, 50, cooldown = 3, levelRequirement = 45, manaCost = 17, statInterpolation = { }, },
		[12] = { 3000, 1, 66, 33, 75, 4, 52, cooldown = 3, levelRequirement = 48, manaCost = 17, statInterpolation = { }, },
		[13] = { 3000, 1, 72, 36, 75, 4, 54, cooldown = 3, levelRequirement = 51, manaCost = 17, statInterpolation = { }, },
		[14] = { 3000, 1, 78, 39, 75, 4, 56, cooldown = 3, levelRequirement = 54, manaCost = 18, statInterpolation = { }, },
		[15] = { 3000, 1, 84, 42, 75, 4, 58, cooldown = 3, levelRequirement = 57, manaCost = 18, statInterpolation = { }, },
		[16] = { 3000, 1, 90, 45, 75, 4, 60, cooldown = 3, levelRequirement = 60, manaCost = 18, statInterpolation = { }, },
		[17] = { 3000, 1, 96, 48, 75, 4, 62, cooldown = 3, levelRequirement = 63, manaCost = 19, statInterpolation = { }, },
		[18] = { 3000, 1, 102, 51, 75, 4, 64, cooldown = 3, levelRequirement = 66, manaCost = 19, statInterpolation = { }, },
		[19] = { 3000, 1, 108, 54, 75, 4, 66, cooldown = 3, levelRequirement = 68, manaCost = 20, statInterpolation = { }, },
		[20] = { 3000, 1, 114, 57, 75, 4, 68, cooldown = 3, levelRequirement = 70, manaCost = 20, statInterpolation = { }, },
		[21] = { 3000, 1, 120, 60, 75, 4, 70, cooldown = 3, levelRequirement = 72, manaCost = 21, statInterpolation = { }, },
		[22] = { 3000, 1, 126, 63, 75, 4, 72, cooldown = 3, levelRequirement = 74, manaCost = 21, statInterpolation = { }, },
		[23] = { 3000, 1, 132, 66, 75, 4, 74, cooldown = 3, levelRequirement = 76, manaCost = 22, statInterpolation = { }, },
		[24] = { 3000, 1, 138, 69, 75, 4, 76, cooldown = 3, levelRequirement = 78, manaCost = 22, statInterpolation = { }, },
		[25] = { 3000, 1, 144, 72, 75, 4, 78, cooldown = 3, levelRequirement = 80, manaCost = 22, statInterpolation = { }, },
		[26] = { 3000, 1, 150, 75, 75, 4, 80, cooldown = 3, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 3000, 1, 156, 78, 75, 4, 82, cooldown = 3, levelRequirement = 84, manaCost = 23, statInterpolation = { }, },
		[28] = { 3000, 1, 162, 81, 75, 4, 84, cooldown = 3, levelRequirement = 86, manaCost = 23, statInterpolation = { }, },
		[29] = { 3000, 1, 168, 84, 75, 4, 86, cooldown = 3, levelRequirement = 88, manaCost = 23, statInterpolation = { }, },
		[30] = { 3000, 1, 174, 87, 75, 4, 88, cooldown = 3, levelRequirement = 90, manaCost = 24, statInterpolation = { }, },
	},
}
skills["NewPhaseRun"] = {
	name = "Phase Run",
	color = 2,
	description = "Gain a buff that makes you faster, harder to detect, and grants Phasing, letting you pass through enemies. Performing any skill replaces this buff with one that boosts melee damage. Consumes Frenzy Charges to increase duration.",
	skillTypes = { [2] = true, [5] = true, [12] = true, [36] = true, [38] = true, },
	castTime = 0.5,
	statMap = {
		["phase_run_melee_physical_damage_+%_final"] = {
			mod("PhysicalDamage", "MORE", nil, ModFlag.Melee, 0, { type = "SkillType", skillType = SkillType.Totem, neg = true }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_movement_velocity_+%", 0.5 },
	},
	stats = {
		"base_movement_velocity_+%",
		"phase_run_melee_physical_damage_+%_final",
		"enemy_aggro_radius_+%",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
		"skill_effect_duration_+%_per_frenzy_charge",
		"phase_through_objects",
	},
	levels = {
		[1] = { 30, 20, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 34, manaCost = 11, statInterpolation = { }, },
		[2] = { 30, 21, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 36, manaCost = 11, statInterpolation = { }, },
		[3] = { 31, 21, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 38, manaCost = 11, statInterpolation = { }, },
		[4] = { 31, 22, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 40, manaCost = 11, statInterpolation = { }, },
		[5] = { 32, 22, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 42, manaCost = 11, statInterpolation = { }, },
		[6] = { 32, 23, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 44, manaCost = 12, statInterpolation = { }, },
		[7] = { 33, 23, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 46, manaCost = 12, statInterpolation = { }, },
		[8] = { 33, 24, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 48, manaCost = 12, statInterpolation = { }, },
		[9] = { 34, 24, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 50, manaCost = 12, statInterpolation = { }, },
		[10] = { 34, 25, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 52, manaCost = 12, statInterpolation = { }, },
		[11] = { 35, 25, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 54, manaCost = 12, statInterpolation = { }, },
		[12] = { 35, 26, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 56, manaCost = 12, statInterpolation = { }, },
		[13] = { 36, 26, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 58, manaCost = 13, statInterpolation = { }, },
		[14] = { 36, 27, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 60, manaCost = 13, statInterpolation = { }, },
		[15] = { 37, 27, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 62, manaCost = 13, statInterpolation = { }, },
		[16] = { 37, 28, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 64, manaCost = 13, statInterpolation = { }, },
		[17] = { 38, 28, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 66, manaCost = 13, statInterpolation = { }, },
		[18] = { 38, 29, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 68, manaCost = 13, statInterpolation = { }, },
		[19] = { 39, 29, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 69, manaCost = 14, statInterpolation = { }, },
		[20] = { 39, 30, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 70, manaCost = 14, statInterpolation = { }, },
		[21] = { 40, 30, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 72, manaCost = 14, statInterpolation = { }, },
		[22] = { 40, 31, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 74, manaCost = 14, statInterpolation = { }, },
		[23] = { 41, 31, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 76, manaCost = 14, statInterpolation = { }, },
		[24] = { 41, 32, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 78, manaCost = 14, statInterpolation = { }, },
		[25] = { 42, 32, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 80, manaCost = 14, statInterpolation = { }, },
		[26] = { 42, 33, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 82, manaCost = 14, statInterpolation = { }, },
		[27] = { 43, 33, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 84, manaCost = 14, statInterpolation = { }, },
		[28] = { 43, 34, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 86, manaCost = 14, statInterpolation = { }, },
		[29] = { 44, 34, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 88, manaCost = 14, statInterpolation = { }, },
		[30] = { 44, 35, -80, 1800, 200, 100, cooldown = 4, levelRequirement = 90, manaCost = 14, statInterpolation = { }, },
	},
}
skills["PoachersMark"] = {
	name = "Poacher's Mark",
	color = 2,
	description = "Curses all targets in an area, making them less evasive. Hitting the cursed targets will grant life and mana, and killing them will result in more flask charges and a chance to gain a frenzy charge.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [26] = true, [32] = true, [36] = true, },
	castTime = 0.5,
	statMap = {
		["evasion_rating_+%_final_from_poachers_mark"] = {
			mod("Evasion", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["life_granted_when_hit_by_attacks"] = {
			mod("SelfLifeOnHit", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["mana_granted_when_hit_by_attacks"] = {
			mod("SelfManaOnHit", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "chance_to_grant_frenzy_charge_on_death_%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_area_of_effect_+%",
		"evasion_rating_+%_final_from_poachers_mark",
		"monster_slain_flask_charges_granted_+%",
		"life_granted_when_hit_by_attacks",
		"mana_granted_when_hit_by_attacks",
		"chance_to_grant_frenzy_charge_on_death_%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 6000, 0, -30, 100, 5, 5, 21, manaCost = 24, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 6200, 4, -31, 100, 6, 6, 21, manaCost = 26, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 6400, 8, -32, 100, 7, 6, 22, manaCost = 27, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 6600, 12, -33, 100, 8, 6, 22, manaCost = 29, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 6800, 16, -34, 100, 9, 7, 23, manaCost = 30, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 7000, 20, -35, 100, 10, 7, 23, manaCost = 32, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 7200, 24, -36, 100, 11, 7, 24, manaCost = 34, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 7400, 28, -37, 100, 12, 8, 24, manaCost = 35, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 7600, 32, -38, 100, 13, 8, 25, manaCost = 37, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 7800, 36, -39, 100, 14, 8, 25, manaCost = 38, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 8000, 40, -40, 100, 15, 9, 26, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 8200, 44, -41, 100, 16, 9, 26, manaCost = 40, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 8400, 48, -42, 100, 17, 9, 27, manaCost = 42, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 8600, 52, -43, 100, 18, 10, 27, manaCost = 43, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 8800, 56, -44, 100, 19, 10, 28, manaCost = 44, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 9000, 60, -45, 100, 20, 10, 28, manaCost = 45, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 9200, 64, -46, 100, 21, 11, 29, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 9400, 68, -47, 100, 22, 11, 29, manaCost = 47, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 9600, 72, -48, 100, 23, 11, 30, manaCost = 48, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 9800, 76, -49, 100, 24, 12, 30, manaCost = 50, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 10000, 80, -50, 100, 25, 12, 31, manaCost = 51, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 10200, 84, -51, 100, 26, 12, 31, manaCost = 52, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 10400, 88, -52, 100, 27, 13, 32, manaCost = 53, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 10600, 92, -53, 100, 28, 13, 32, manaCost = 54, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 10800, 96, -54, 100, 29, 13, 33, manaCost = 56, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 11000, 100, -55, 100, 30, 14, 33, manaCost = 57, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 11200, 104, -56, 100, 31, 14, 34, manaCost = 58, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 11400, 108, -57, 100, 32, 14, 34, manaCost = 59, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 11600, 112, -58, 100, 33, 15, 35, manaCost = 60, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 11800, 116, -59, 100, 34, 15, 35, manaCost = 61, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["ProjectileWeakness"] = {
	name = "Projectile Weakness",
	color = 2,
	description = "Curses all targets in an area, making them easier to pierce and to knock back, and increasing the damage they take from projectiles.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [26] = true, [32] = true, [36] = true, },
	castTime = 0.5,
	statMap = {
		["projectiles_always_pierce_you"] = {
			flag("AlwaysPierceSelf", { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_knocked_back_%"] = {
			mod("SelfKnockbackChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "projectile_damage_taken_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_area_of_effect_+%",
		"chance_to_be_pierced_%",
		"chance_to_be_knocked_back_%",
		"projectile_damage_taken_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 9000, 0, 50, 25, 25, manaCost = 24, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 9100, 4, 50, 25, 26, manaCost = 26, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 9200, 8, 50, 25, 27, manaCost = 27, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 9300, 12, 50, 25, 28, manaCost = 29, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 9400, 16, 50, 25, 29, manaCost = 30, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 9500, 20, 50, 25, 30, manaCost = 32, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 9600, 24, 50, 25, 31, manaCost = 34, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 9700, 28, 50, 25, 32, manaCost = 35, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 9800, 32, 50, 25, 33, manaCost = 37, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 9900, 36, 50, 25, 34, manaCost = 38, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 10000, 40, 50, 25, 35, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 10100, 44, 50, 25, 36, manaCost = 40, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 10200, 48, 50, 25, 37, manaCost = 42, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 10300, 52, 50, 25, 38, manaCost = 43, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 10400, 56, 50, 25, 39, manaCost = 44, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 10500, 60, 50, 25, 40, manaCost = 45, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 10600, 64, 50, 25, 41, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 10700, 68, 50, 25, 42, manaCost = 47, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 10800, 72, 50, 25, 43, manaCost = 48, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 10900, 76, 50, 25, 44, manaCost = 50, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 11000, 80, 50, 25, 45, manaCost = 51, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 11100, 84, 50, 25, 46, manaCost = 52, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 11200, 88, 50, 25, 47, manaCost = 53, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 11300, 92, 50, 25, 48, manaCost = 54, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 11400, 96, 50, 25, 49, manaCost = 56, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 11500, 100, 50, 25, 50, manaCost = 57, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 11600, 104, 50, 25, 51, manaCost = 58, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 11700, 108, 50, 25, 52, manaCost = 59, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 11800, 112, 50, 25, 53, manaCost = 60, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 11900, 116, 50, 25, 54, manaCost = 61, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Puncture"] = {
	name = "Puncture",
	color = 2,
	description = "Punctures the target, causing a bleeding debuff. While bleeding, they take damage over time based on how much damage was dealt in the initial hit. The bleeding deals more damage while they move. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [6] = true, [12] = true, [17] = true, [19] = true, [22] = true, [25] = true, [28] = true, [24] = true, [40] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1 },
	},
	stats = {
		"base_bleed_on_hit_still_%_of_physical_damage_to_deal_per_minute",
		"base_bleed_on_hit_moving_%_of_physical_damage_to_deal_per_minute",
		"bleed_on_hit_base_duration",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 600, 3000, 5000, manaCost = 6, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 600, 3000, 5000, damageMultiplier = 1.2, levelRequirement = 6, manaCost = 6, statInterpolation = { }, },
		[3] = { 600, 3000, 5000, damageMultiplier = 2.4, levelRequirement = 9, manaCost = 6, statInterpolation = { }, },
		[4] = { 600, 3000, 5000, damageMultiplier = 3.6, levelRequirement = 12, manaCost = 6, statInterpolation = { }, },
		[5] = { 600, 3000, 5000, damageMultiplier = 4.8, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[6] = { 600, 3000, 5000, damageMultiplier = 6, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[7] = { 600, 3000, 5000, damageMultiplier = 7.2, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[8] = { 600, 3000, 5000, damageMultiplier = 8.4, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[9] = { 600, 3000, 5000, damageMultiplier = 9.6, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[10] = { 600, 3000, 5000, damageMultiplier = 10.8, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[11] = { 600, 3000, 5000, damageMultiplier = 12, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[12] = { 600, 3000, 5000, damageMultiplier = 13.2, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[13] = { 600, 3000, 5000, damageMultiplier = 14.4, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[14] = { 600, 3000, 5000, damageMultiplier = 15.6, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[15] = { 600, 3000, 5000, damageMultiplier = 16.8, levelRequirement = 55, manaCost = 6, statInterpolation = { }, },
		[16] = { 600, 3000, 5000, damageMultiplier = 18, levelRequirement = 58, manaCost = 6, statInterpolation = { }, },
		[17] = { 600, 3000, 5000, damageMultiplier = 19.2, levelRequirement = 61, manaCost = 6, statInterpolation = { }, },
		[18] = { 600, 3000, 5000, damageMultiplier = 20.4, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 600, 3000, 5000, damageMultiplier = 21.6, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 600, 3000, 5000, damageMultiplier = 22.8, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 600, 3000, 5000, damageMultiplier = 24, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 600, 3000, 5000, damageMultiplier = 25.2, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 600, 3000, 5000, damageMultiplier = 26.4, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 600, 3000, 5000, damageMultiplier = 27.6, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 600, 3000, 5000, damageMultiplier = 28.8, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 600, 3000, 5000, damageMultiplier = 30, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 600, 3000, 5000, damageMultiplier = 31.2, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 600, 3000, 5000, damageMultiplier = 32.4, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 600, 3000, 5000, damageMultiplier = 33.6, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 600, 3000, 5000, damageMultiplier = 34.8, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["ColdResistAura"] = {
	name = "Purity of Ice",
	color = 2,
	description = "Casts an aura that grants cold resistance to you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, [34] = true, },
	castTime = 1.2,
	statMap = {
		["base_cold_damage_resistance_%"] = {
			mod("ColdResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_cold_damage_resistance_%"] = {
			mod("ColdResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"base_cold_damage_resistance_%",
		"base_maximum_cold_damage_resistance_%",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 22, 0, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 35, statInterpolation = { }, },
		[2] = { 23, 0, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 35, statInterpolation = { }, },
		[3] = { 24, 0, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 35, statInterpolation = { }, },
		[4] = { 25, 0, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 35, statInterpolation = { }, },
		[5] = { 26, 1, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 35, statInterpolation = { }, },
		[6] = { 27, 1, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 35, statInterpolation = { }, },
		[7] = { 28, 1, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 35, statInterpolation = { }, },
		[8] = { 29, 1, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 35, statInterpolation = { }, },
		[9] = { 30, 1, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 35, statInterpolation = { }, },
		[10] = { 31, 1, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 35, statInterpolation = { }, },
		[11] = { 32, 2, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 35, statInterpolation = { }, },
		[12] = { 33, 2, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 35, statInterpolation = { }, },
		[13] = { 34, 2, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 35, statInterpolation = { }, },
		[14] = { 35, 2, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 35, statInterpolation = { }, },
		[15] = { 36, 2, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 35, statInterpolation = { }, },
		[16] = { 37, 2, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 35, statInterpolation = { }, },
		[17] = { 38, 3, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 35, statInterpolation = { }, },
		[18] = { 39, 3, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 35, statInterpolation = { }, },
		[19] = { 40, 3, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 35, statInterpolation = { }, },
		[20] = { 41, 4, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 35, statInterpolation = { }, },
		[21] = { 42, 4, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 35, statInterpolation = { }, },
		[22] = { 43, 4, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 35, statInterpolation = { }, },
		[23] = { 44, 5, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 35, statInterpolation = { }, },
		[24] = { 45, 5, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 35, statInterpolation = { }, },
		[25] = { 46, 5, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 35, statInterpolation = { }, },
		[26] = { 47, 5, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 35, statInterpolation = { }, },
		[27] = { 48, 5, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 35, statInterpolation = { }, },
		[28] = { 49, 5, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 35, statInterpolation = { }, },
		[29] = { 50, 5, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 35, statInterpolation = { }, },
		[30] = { 51, 5, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 35, statInterpolation = { }, },
	},
}
skills["RainOfArrows"] = {
	name = "Rain of Arrows",
	color = 2,
	description = "Fires a large number of arrows into the air, to land at the target after a short delay.",
	skillTypes = { [1] = true, [48] = true, [11] = true, [14] = true, [22] = true, [17] = true, [19] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"active_skill_base_radius_+",
		"base_is_projectile",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, damageMultiplier = 10, levelRequirement = 12, manaCost = 7, statInterpolation = { }, },
		[2] = { 0, damageMultiplier = 11, levelRequirement = 15, manaCost = 7, statInterpolation = { }, },
		[3] = { 0, damageMultiplier = 12, levelRequirement = 19, manaCost = 7, statInterpolation = { }, },
		[4] = { 0, damageMultiplier = 13, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { 1, damageMultiplier = 14, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { 1, damageMultiplier = 15, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { 1, damageMultiplier = 16, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { 1, damageMultiplier = 17, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { 1, damageMultiplier = 18, levelRequirement = 41, manaCost = 9, statInterpolation = { }, },
		[10] = { 2, damageMultiplier = 19, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[11] = { 2, damageMultiplier = 20, levelRequirement = 47, manaCost = 9, statInterpolation = { }, },
		[12] = { 2, damageMultiplier = 21, levelRequirement = 50, manaCost = 9, statInterpolation = { }, },
		[13] = { 2, damageMultiplier = 22, levelRequirement = 53, manaCost = 9, statInterpolation = { }, },
		[14] = { 2, damageMultiplier = 23, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[15] = { 3, damageMultiplier = 24, levelRequirement = 59, manaCost = 10, statInterpolation = { }, },
		[16] = { 3, damageMultiplier = 25, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 3, damageMultiplier = 26, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 3, damageMultiplier = 27, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 3, damageMultiplier = 28, levelRequirement = 68, manaCost = 11, statInterpolation = { }, },
		[20] = { 4, damageMultiplier = 29, levelRequirement = 70, manaCost = 11, statInterpolation = { }, },
		[21] = { 4, damageMultiplier = 30, levelRequirement = 72, manaCost = 11, statInterpolation = { }, },
		[22] = { 4, damageMultiplier = 31, levelRequirement = 74, manaCost = 11, statInterpolation = { }, },
		[23] = { 4, damageMultiplier = 32, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 4, damageMultiplier = 33, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 5, damageMultiplier = 34, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 5, damageMultiplier = 35, levelRequirement = 82, manaCost = 12, statInterpolation = { }, },
		[27] = { 5, damageMultiplier = 36, levelRequirement = 84, manaCost = 12, statInterpolation = { }, },
		[28] = { 5, damageMultiplier = 37, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 5, damageMultiplier = 38, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 6, damageMultiplier = 39, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["VaalRainOfArrows"] = {
	name = "Vaal Rain of Arrows",
	color = 2,
	description = "Fires a large number of arrows into the air, to land at the target after a short delay. Enemies hit by the arrows are pinned in place, unable to move for a time.",
	skillTypes = { [1] = true, [48] = true, [11] = true, [14] = true, [22] = true, [17] = true, [19] = true, [12] = true, [43] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_area_of_effect_+%",
		"base_is_projectile",
		"is_area_damage",
		"rain_of_arrows_pin",
		"global_always_hit",
	},
	levels = {
		[1] = { 3400, 0, damageMultiplier = 40, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 3450, 1, damageMultiplier = 41.5, levelRequirement = 15, statInterpolation = { }, },
		[3] = { 3500, 2, damageMultiplier = 43, levelRequirement = 19, statInterpolation = { }, },
		[4] = { 3550, 3, damageMultiplier = 44.5, levelRequirement = 23, statInterpolation = { }, },
		[5] = { 3600, 4, damageMultiplier = 46, levelRequirement = 27, statInterpolation = { }, },
		[6] = { 3650, 5, damageMultiplier = 47.5, levelRequirement = 31, statInterpolation = { }, },
		[7] = { 3700, 6, damageMultiplier = 49, levelRequirement = 35, statInterpolation = { }, },
		[8] = { 3750, 7, damageMultiplier = 50.5, levelRequirement = 38, statInterpolation = { }, },
		[9] = { 3800, 8, damageMultiplier = 52, levelRequirement = 41, statInterpolation = { }, },
		[10] = { 3850, 9, damageMultiplier = 53.5, levelRequirement = 44, statInterpolation = { }, },
		[11] = { 3900, 10, damageMultiplier = 55, levelRequirement = 47, statInterpolation = { }, },
		[12] = { 3950, 11, damageMultiplier = 56.5, levelRequirement = 50, statInterpolation = { }, },
		[13] = { 4000, 12, damageMultiplier = 58, levelRequirement = 53, statInterpolation = { }, },
		[14] = { 4050, 13, damageMultiplier = 59.5, levelRequirement = 56, statInterpolation = { }, },
		[15] = { 4100, 14, damageMultiplier = 61, levelRequirement = 59, statInterpolation = { }, },
		[16] = { 4150, 15, damageMultiplier = 62.5, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 4200, 16, damageMultiplier = 64, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 4250, 17, damageMultiplier = 65.5, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 4300, 18, damageMultiplier = 67, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 4350, 19, damageMultiplier = 68.5, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 4400, 20, damageMultiplier = 70, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 4450, 21, damageMultiplier = 71.5, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 4500, 22, damageMultiplier = 73, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 4550, 23, damageMultiplier = 74.5, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 4600, 24, damageMultiplier = 76, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 4650, 25, damageMultiplier = 77.5, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 4700, 26, damageMultiplier = 79, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 4750, 27, damageMultiplier = 80.5, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 4800, 28, damageMultiplier = 82, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 4850, 29, damageMultiplier = 83.5, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Reave"] = {
	name = "Reave",
	color = 2,
	description = "Attacks a small area in front of you. Each Reave that hits an enemy increases the area of effect. The area is reset after a short period without hitting anything. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "No stages",
		},
		{
			name = "4 stages",
		},
		{ 
			name = "8 stages",
		},
	},
	statMap = {
		["reave_area_of_effect_+%_final_per_stage"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "ReaveStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 14),
		mod("Multiplier:ReaveStage", "BASE", 4, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ReaveStage", "BASE", 8, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"reave_area_of_effect_+%_final_per_stage",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, 0, manaCost = 6, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 50, 0, damageMultiplier = 2, levelRequirement = 15, manaCost = 6, statInterpolation = { }, },
		[3] = { 50, 0, damageMultiplier = 4, levelRequirement = 19, manaCost = 6, statInterpolation = { }, },
		[4] = { 50, 0, damageMultiplier = 6, levelRequirement = 23, manaCost = 6, statInterpolation = { }, },
		[5] = { 50, 1, damageMultiplier = 8, levelRequirement = 27, manaCost = 6, statInterpolation = { }, },
		[6] = { 50, 1, damageMultiplier = 10, levelRequirement = 31, manaCost = 6, statInterpolation = { }, },
		[7] = { 50, 1, damageMultiplier = 12, levelRequirement = 35, manaCost = 6, statInterpolation = { }, },
		[8] = { 50, 1, damageMultiplier = 14, levelRequirement = 38, manaCost = 6, statInterpolation = { }, },
		[9] = { 50, 1, damageMultiplier = 16, levelRequirement = 41, manaCost = 6, statInterpolation = { }, },
		[10] = { 50, 2, damageMultiplier = 18, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[11] = { 50, 2, damageMultiplier = 20, levelRequirement = 47, manaCost = 6, statInterpolation = { }, },
		[12] = { 50, 2, damageMultiplier = 22, levelRequirement = 50, manaCost = 6, statInterpolation = { }, },
		[13] = { 50, 2, damageMultiplier = 24, levelRequirement = 53, manaCost = 6, statInterpolation = { }, },
		[14] = { 50, 2, damageMultiplier = 26, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[15] = { 50, 3, damageMultiplier = 28, levelRequirement = 59, manaCost = 6, statInterpolation = { }, },
		[16] = { 50, 3, damageMultiplier = 30, levelRequirement = 62, manaCost = 6, statInterpolation = { }, },
		[17] = { 50, 3, damageMultiplier = 32, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[18] = { 50, 3, damageMultiplier = 34, levelRequirement = 66, manaCost = 6, statInterpolation = { }, },
		[19] = { 50, 3, damageMultiplier = 36, levelRequirement = 68, manaCost = 6, statInterpolation = { }, },
		[20] = { 50, 4, damageMultiplier = 38, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 50, 4, damageMultiplier = 40, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 50, 4, damageMultiplier = 42, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 50, 4, damageMultiplier = 44, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 50, 4, damageMultiplier = 46, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 50, 5, damageMultiplier = 48, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 50, 5, damageMultiplier = 50, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 50, 5, damageMultiplier = 52, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 50, 5, damageMultiplier = 54, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 50, 5, damageMultiplier = 56, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 50, 6, damageMultiplier = 58, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["VaalReave"] = {
	name = "Vaal Reave",
	color = 2,
	description = "Repeatedly attacks a large area in different directions. Each Vaal Reave that hits an enemy increases the area of effect. The area is reset after a short period without hitting anything. Only works with Daggers, Claws, and One-Handed Swords.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [28] = true, [24] = true, [43] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["One Handed Sword"] = true,
		["Dagger"] = true,
		["Claw"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "No stages",
		},
		{
			name = "4 stages",
		},
		{ 
			name = "8 stages",
		},
	},
	statMap = {
		["reave_area_of_effect_+%_final_per_stage"] = {
			mod("AreaOfEffect", "MORE", nil, 0, 0, { type = "Multiplier", var = "ReaveStage" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
		mod("Multiplier:ReaveStage", "BASE", 4, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("Multiplier:ReaveStage", "BASE", 8, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"reave_area_of_effect_+%_final_per_stage",
		"reave_rotation_on_repeat",
		"reave_additional_max_stacks",
		"base_attack_repeat_count",
		"active_skill_attack_speed_+%_final",
		"reave_additional_starting_stacks",
		"active_skill_base_radius_+",
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { 50, 135, 4, 7, 150, 4, 0, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 50, 135, 4, 7, 150, 4, 0, damageMultiplier = 1.2, levelRequirement = 15, statInterpolation = { }, },
		[3] = { 50, 135, 4, 7, 150, 4, 0, damageMultiplier = 2.4, levelRequirement = 19, statInterpolation = { }, },
		[4] = { 50, 135, 4, 7, 150, 4, 0, damageMultiplier = 3.6, levelRequirement = 23, statInterpolation = { }, },
		[5] = { 50, 135, 4, 7, 150, 4, 1, damageMultiplier = 4.8, levelRequirement = 27, statInterpolation = { }, },
		[6] = { 50, 135, 4, 7, 150, 4, 1, damageMultiplier = 6, levelRequirement = 31, statInterpolation = { }, },
		[7] = { 50, 135, 4, 7, 150, 4, 1, damageMultiplier = 7.2, levelRequirement = 35, statInterpolation = { }, },
		[8] = { 50, 135, 4, 7, 150, 4, 1, damageMultiplier = 8.4, levelRequirement = 38, statInterpolation = { }, },
		[9] = { 50, 135, 4, 7, 150, 4, 1, damageMultiplier = 9.6, levelRequirement = 41, statInterpolation = { }, },
		[10] = { 50, 135, 4, 7, 150, 4, 2, damageMultiplier = 10.8, levelRequirement = 44, statInterpolation = { }, },
		[11] = { 50, 135, 4, 7, 150, 4, 2, damageMultiplier = 12, levelRequirement = 47, statInterpolation = { }, },
		[12] = { 50, 135, 4, 7, 150, 4, 2, damageMultiplier = 13.2, levelRequirement = 50, statInterpolation = { }, },
		[13] = { 50, 135, 4, 7, 150, 4, 2, damageMultiplier = 14.4, levelRequirement = 53, statInterpolation = { }, },
		[14] = { 50, 135, 4, 7, 150, 4, 2, damageMultiplier = 15.6, levelRequirement = 56, statInterpolation = { }, },
		[15] = { 50, 135, 4, 7, 150, 4, 3, damageMultiplier = 16.8, levelRequirement = 59, statInterpolation = { }, },
		[16] = { 50, 135, 4, 7, 150, 4, 3, damageMultiplier = 18, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 50, 135, 4, 7, 150, 4, 3, damageMultiplier = 19.2, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 50, 135, 4, 7, 150, 4, 3, damageMultiplier = 20.4, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 50, 135, 4, 7, 150, 4, 3, damageMultiplier = 21.6, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 50, 135, 4, 7, 150, 4, 4, damageMultiplier = 22.8, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 50, 135, 4, 7, 150, 4, 4, damageMultiplier = 24, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 50, 135, 4, 7, 150, 4, 4, damageMultiplier = 25.2, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 50, 135, 4, 7, 150, 4, 4, damageMultiplier = 26.4, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 50, 135, 4, 7, 150, 4, 4, damageMultiplier = 27.6, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 50, 135, 4, 7, 150, 4, 5, damageMultiplier = 28.8, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 50, 135, 4, 7, 150, 4, 5, damageMultiplier = 30, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 50, 135, 4, 7, 150, 4, 5, damageMultiplier = 31.2, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 50, 135, 4, 7, 150, 4, 5, damageMultiplier = 32.4, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 50, 135, 4, 7, 150, 4, 5, damageMultiplier = 33.6, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 50, 135, 4, 7, 150, 4, 6, damageMultiplier = 34.8, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Riposte"] = {
	name = "Riposte",
	color = 2,
	description = "Perform a deadly counter-attack when you block. Uses both weapons while you're dual wielding.",
	skillTypes = { [1] = true, [24] = true, [25] = true, [6] = true, [47] = true, [57] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
	},
	stats = {
		"melee_counterattack_trigger_on_block_%",
		"attack_unusable_if_triggerable",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { 100, cooldown = 0.8, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 100, damageMultiplier = 2, cooldown = 0.8, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 100, damageMultiplier = 4, cooldown = 0.8, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 100, damageMultiplier = 6, cooldown = 0.8, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 100, damageMultiplier = 8, cooldown = 0.8, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 100, damageMultiplier = 10, cooldown = 0.8, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 100, damageMultiplier = 12, cooldown = 0.8, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 100, damageMultiplier = 14, cooldown = 0.8, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 100, damageMultiplier = 16, cooldown = 0.8, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 100, damageMultiplier = 18, cooldown = 0.8, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 100, damageMultiplier = 20, cooldown = 0.8, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 100, damageMultiplier = 22, cooldown = 0.8, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 100, damageMultiplier = 24, cooldown = 0.8, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 100, damageMultiplier = 26, cooldown = 0.8, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 100, damageMultiplier = 28, cooldown = 0.8, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 100, damageMultiplier = 30, cooldown = 0.8, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 100, damageMultiplier = 32, cooldown = 0.8, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 100, damageMultiplier = 34, cooldown = 0.8, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 100, damageMultiplier = 36, cooldown = 0.8, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 100, damageMultiplier = 38, cooldown = 0.8, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 100, damageMultiplier = 40, cooldown = 0.8, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, damageMultiplier = 42, cooldown = 0.8, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 100, damageMultiplier = 44, cooldown = 0.8, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 100, damageMultiplier = 46, cooldown = 0.8, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 100, damageMultiplier = 48, cooldown = 0.8, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 100, damageMultiplier = 50, cooldown = 0.8, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 100, damageMultiplier = 52, cooldown = 0.8, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 100, damageMultiplier = 54, cooldown = 0.8, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 100, damageMultiplier = 56, cooldown = 0.8, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 100, damageMultiplier = 58, cooldown = 0.8, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["ShrapnelShot"] = {
	name = "Shrapnel Shot",
	color = 2,
	description = "Fires an arrow that pierces through enemies. Arrows are fired with such force that they create a burst of lightning, damaging all enemies in a cone in front of the archer.",
	skillTypes = { [1] = true, [3] = true, [11] = true, [22] = true, [17] = true, [19] = true, [35] = true, [48] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Arrow",
			area = false,
		},
		{
			name = "Cone",
			area = true,
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_arrow_pierce_%",
		"active_skill_area_damage_+%_final",
		"base_physical_damage_%_to_convert_to_lightning",
		"active_skill_base_radius_+",
		"base_is_projectile",
		"skill_can_fire_arrows",
		"always_pierce",
	},
	levels = {
		[1] = { 100, 0, 40, 0, damageMultiplier = -20, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 100, 0, 40, 0, damageMultiplier = -19, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 100, 0, 40, 0, damageMultiplier = -18, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 100, 0, 40, 1, damageMultiplier = -17, levelRequirement = 7, manaCost = 7, statInterpolation = { }, },
		[5] = { 100, 0, 40, 1, damageMultiplier = -16, levelRequirement = 11, manaCost = 7, statInterpolation = { }, },
		[6] = { 100, 0, 40, 1, damageMultiplier = -15, levelRequirement = 16, manaCost = 7, statInterpolation = { }, },
		[7] = { 100, 0, 40, 1, damageMultiplier = -14, levelRequirement = 20, manaCost = 7, statInterpolation = { }, },
		[8] = { 100, 0, 40, 2, damageMultiplier = -13, levelRequirement = 24, manaCost = 8, statInterpolation = { }, },
		[9] = { 100, 0, 40, 2, damageMultiplier = -12, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[10] = { 100, 0, 40, 2, damageMultiplier = -11, levelRequirement = 32, manaCost = 8, statInterpolation = { }, },
		[11] = { 100, 0, 40, 2, damageMultiplier = -10, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[12] = { 100, 0, 40, 3, damageMultiplier = -9, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[13] = { 100, 0, 40, 3, damageMultiplier = -8, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[14] = { 100, 0, 40, 3, damageMultiplier = -7, levelRequirement = 48, manaCost = 9, statInterpolation = { }, },
		[15] = { 100, 0, 40, 3, damageMultiplier = -6, levelRequirement = 52, manaCost = 9, statInterpolation = { }, },
		[16] = { 100, 0, 40, 4, damageMultiplier = -5, levelRequirement = 56, manaCost = 9, statInterpolation = { }, },
		[17] = { 100, 0, 40, 4, damageMultiplier = -4, levelRequirement = 60, manaCost = 9, statInterpolation = { }, },
		[18] = { 100, 0, 40, 4, damageMultiplier = -3, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[19] = { 100, 0, 40, 4, damageMultiplier = -2, levelRequirement = 67, manaCost = 10, statInterpolation = { }, },
		[20] = { 100, 0, 40, 5, damageMultiplier = -1, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 100, 0, 40, 5, manaCost = 10, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, 0, 40, 5, damageMultiplier = 1, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 100, 0, 40, 5, damageMultiplier = 2, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 100, 0, 40, 6, damageMultiplier = 3, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 100, 0, 40, 6, damageMultiplier = 4, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 100, 0, 40, 6, damageMultiplier = 5, levelRequirement = 82, manaCost = 11, statInterpolation = { }, },
		[27] = { 100, 0, 40, 6, damageMultiplier = 6, levelRequirement = 84, manaCost = 11, statInterpolation = { }, },
		[28] = { 100, 0, 40, 7, damageMultiplier = 7, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 100, 0, 40, 7, damageMultiplier = 8, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 100, 0, 40, 7, damageMultiplier = 9, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["SiegeBallista"] = {
	name = "Siege Ballista",
	color = 2,
	description = "Summons a totem that attacks with piercing arrows. It attacks slowly, but deals increased damage.",
	skillTypes = { [1] = true, [3] = true, [48] = true, [17] = true, [19] = true, [30] = true, [12] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	skillTotemId = 12,
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		totem = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "summon_totem_cast_speed_+%", 1 },
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"base_arrow_pierce_%",
		"base_totem_range",
		"base_totem_duration",
		"base_active_skill_totem_level",
		"base_is_projectile",
		"base_skill_is_totemified",
		"is_totem",
		"skill_can_fire_arrows",
		"always_pierce",
	},
	levels = {
		[1] = { -50, 100, 80, 8000, 4, damageMultiplier = 40, levelRequirement = 4, manaCost = 8, statInterpolation = { }, },
		[2] = { -50, 100, 80, 8000, 6, damageMultiplier = 41.6, levelRequirement = 6, manaCost = 8, statInterpolation = { }, },
		[3] = { -50, 100, 80, 8000, 9, damageMultiplier = 43.2, levelRequirement = 9, manaCost = 8, statInterpolation = { }, },
		[4] = { -50, 100, 80, 8000, 12, damageMultiplier = 44.8, levelRequirement = 12, manaCost = 9, statInterpolation = { }, },
		[5] = { -50, 100, 80, 8000, 16, damageMultiplier = 46.4, levelRequirement = 16, manaCost = 9, statInterpolation = { }, },
		[6] = { -50, 100, 80, 8000, 20, damageMultiplier = 48, levelRequirement = 20, manaCost = 9, statInterpolation = { }, },
		[7] = { -50, 100, 80, 8000, 24, damageMultiplier = 49.6, levelRequirement = 24, manaCost = 9, statInterpolation = { }, },
		[8] = { -50, 100, 80, 8000, 28, damageMultiplier = 51.2, levelRequirement = 28, manaCost = 9, statInterpolation = { }, },
		[9] = { -50, 100, 80, 8000, 32, damageMultiplier = 52.8, levelRequirement = 32, manaCost = 9, statInterpolation = { }, },
		[10] = { -50, 100, 80, 8000, 36, damageMultiplier = 54.4, levelRequirement = 36, manaCost = 10, statInterpolation = { }, },
		[11] = { -50, 100, 80, 8000, 40, damageMultiplier = 56, levelRequirement = 40, manaCost = 10, statInterpolation = { }, },
		[12] = { -50, 100, 80, 8000, 44, damageMultiplier = 57.6, levelRequirement = 44, manaCost = 10, statInterpolation = { }, },
		[13] = { -50, 100, 80, 8000, 48, damageMultiplier = 59.2, levelRequirement = 48, manaCost = 10, statInterpolation = { }, },
		[14] = { -50, 100, 80, 8000, 52, damageMultiplier = 60.8, levelRequirement = 52, manaCost = 10, statInterpolation = { }, },
		[15] = { -50, 100, 80, 8000, 55, damageMultiplier = 62.4, levelRequirement = 55, manaCost = 11, statInterpolation = { }, },
		[16] = { -50, 100, 80, 8000, 58, damageMultiplier = 64, levelRequirement = 58, manaCost = 11, statInterpolation = { }, },
		[17] = { -50, 100, 80, 8000, 61, damageMultiplier = 65.6, levelRequirement = 61, manaCost = 12, statInterpolation = { }, },
		[18] = { -50, 100, 80, 8000, 64, damageMultiplier = 67.2, levelRequirement = 64, manaCost = 12, statInterpolation = { }, },
		[19] = { -50, 100, 80, 8000, 67, damageMultiplier = 68.8, levelRequirement = 67, manaCost = 12, statInterpolation = { }, },
		[20] = { -50, 100, 80, 8000, 70, damageMultiplier = 70.4, levelRequirement = 70, manaCost = 13, statInterpolation = { }, },
		[21] = { -50, 100, 80, 8000, 72, damageMultiplier = 72, levelRequirement = 72, manaCost = 13, statInterpolation = { }, },
		[22] = { -50, 100, 80, 8000, 74, damageMultiplier = 73.6, levelRequirement = 74, manaCost = 13, statInterpolation = { }, },
		[23] = { -50, 100, 80, 8000, 76, damageMultiplier = 75.2, levelRequirement = 76, manaCost = 14, statInterpolation = { }, },
		[24] = { -50, 100, 80, 8000, 78, damageMultiplier = 76.8, levelRequirement = 78, manaCost = 14, statInterpolation = { }, },
		[25] = { -50, 100, 80, 8000, 80, damageMultiplier = 78.4, levelRequirement = 80, manaCost = 14, statInterpolation = { }, },
		[26] = { -50, 100, 80, 8000, 82, damageMultiplier = 80, levelRequirement = 82, manaCost = 14, statInterpolation = { }, },
		[27] = { -50, 100, 80, 8000, 84, damageMultiplier = 81.6, levelRequirement = 84, manaCost = 14, statInterpolation = { }, },
		[28] = { -50, 100, 80, 8000, 86, damageMultiplier = 83.2, levelRequirement = 86, manaCost = 14, statInterpolation = { }, },
		[29] = { -50, 100, 80, 8000, 88, damageMultiplier = 84.8, levelRequirement = 88, manaCost = 15, statInterpolation = { }, },
		[30] = { -50, 100, 80, 8000, 90, damageMultiplier = 86.4, levelRequirement = 90, manaCost = 15, statInterpolation = { }, },
	},
}
skills["SmokeMine"] = {
	name = "Smoke Mine",
	color = 2,
	description = "Places a mine that will teleport you to it when detonated. It covers both your escape and arrival with a cloud of smoke that blinds enemies, and gives you a temporary buff to movement speed.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [38] = true, [41] = true, },
	castTime = 0.5,
	statMap = {
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		mine = true,
		area = true,
		duration = true,
		buff = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"base_mine_duration",
		"base_skill_effect_duration",
		"base_movement_velocity_+%",
		"is_remote_mine",
		"base_skill_is_mined",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 16000, 4000, 30, manaCost = 6, levelRequirement = 10, statInterpolation = { }, },
		[2] = { 16000, 4100, 30, manaCost = 6, levelRequirement = 13, statInterpolation = { }, },
		[3] = { 16000, 4200, 30, manaCost = 7, levelRequirement = 17, statInterpolation = { }, },
		[4] = { 16000, 4300, 30, manaCost = 7, levelRequirement = 21, statInterpolation = { }, },
		[5] = { 16000, 4400, 30, manaCost = 8, levelRequirement = 25, statInterpolation = { }, },
		[6] = { 16000, 4500, 30, manaCost = 8, levelRequirement = 29, statInterpolation = { }, },
		[7] = { 16000, 4600, 30, manaCost = 9, levelRequirement = 33, statInterpolation = { }, },
		[8] = { 16000, 4700, 30, manaCost = 9, levelRequirement = 36, statInterpolation = { }, },
		[9] = { 16000, 4800, 30, manaCost = 9, levelRequirement = 39, statInterpolation = { }, },
		[10] = { 16000, 4900, 30, manaCost = 10, levelRequirement = 42, statInterpolation = { }, },
		[11] = { 16000, 5000, 30, manaCost = 10, levelRequirement = 45, statInterpolation = { }, },
		[12] = { 16000, 5100, 30, manaCost = 10, levelRequirement = 48, statInterpolation = { }, },
		[13] = { 16000, 5200, 30, manaCost = 10, levelRequirement = 51, statInterpolation = { }, },
		[14] = { 16000, 5300, 30, manaCost = 11, levelRequirement = 54, statInterpolation = { }, },
		[15] = { 16000, 5400, 30, manaCost = 11, levelRequirement = 57, statInterpolation = { }, },
		[16] = { 16000, 5500, 30, manaCost = 11, levelRequirement = 60, statInterpolation = { }, },
		[17] = { 16000, 5600, 30, manaCost = 12, levelRequirement = 63, statInterpolation = { }, },
		[18] = { 16000, 5700, 30, manaCost = 12, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 16000, 5800, 30, manaCost = 12, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 16000, 5900, 30, manaCost = 13, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 16000, 6000, 30, manaCost = 13, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 16000, 6100, 30, manaCost = 13, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 16000, 6200, 30, manaCost = 14, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 16000, 6300, 30, manaCost = 14, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 16000, 6400, 30, manaCost = 14, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 16000, 6500, 30, manaCost = 14, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 16000, 6600, 30, manaCost = 14, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 16000, 6700, 30, manaCost = 14, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 16000, 6800, 30, manaCost = 15, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 16000, 6900, 30, manaCost = 15, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["ThrownWeapon"] = {
	name = "Spectral Throw",
	color = 2,
	description = "Throws a spectral copy of your melee weapon. It flies out and then returns to you, in a spinning attack that strikes enemies in its path.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [6] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("PierceChance", "BASE", 100),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_is_projectile",
	},
	levels = {
		[1] = { damageMultiplier = -46, levelRequirement = 1, manaCost = 7, statInterpolation = { }, },
		[2] = { damageMultiplier = -44, levelRequirement = 2, manaCost = 7, statInterpolation = { }, },
		[3] = { damageMultiplier = -42.1, levelRequirement = 4, manaCost = 7, statInterpolation = { }, },
		[4] = { damageMultiplier = -40.2, levelRequirement = 7, manaCost = 7, statInterpolation = { }, },
		[5] = { damageMultiplier = -38.3, levelRequirement = 11, manaCost = 7, statInterpolation = { }, },
		[6] = { damageMultiplier = -36.4, levelRequirement = 16, manaCost = 7, statInterpolation = { }, },
		[7] = { damageMultiplier = -34.4, levelRequirement = 20, manaCost = 7, statInterpolation = { }, },
		[8] = { damageMultiplier = -32.5, levelRequirement = 24, manaCost = 7, statInterpolation = { }, },
		[9] = { damageMultiplier = -30.6, levelRequirement = 28, manaCost = 7, statInterpolation = { }, },
		[10] = { damageMultiplier = -28.7, levelRequirement = 32, manaCost = 7, statInterpolation = { }, },
		[11] = { damageMultiplier = -26.8, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[12] = { damageMultiplier = -24.8, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[13] = { damageMultiplier = -22.9, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[14] = { damageMultiplier = -21, levelRequirement = 48, manaCost = 8, statInterpolation = { }, },
		[15] = { damageMultiplier = -19.1, levelRequirement = 52, manaCost = 8, statInterpolation = { }, },
		[16] = { damageMultiplier = -17.2, levelRequirement = 56, manaCost = 9, statInterpolation = { }, },
		[17] = { damageMultiplier = -15.2, levelRequirement = 60, manaCost = 9, statInterpolation = { }, },
		[18] = { damageMultiplier = -13.3, levelRequirement = 64, manaCost = 9, statInterpolation = { }, },
		[19] = { damageMultiplier = -11.4, levelRequirement = 67, manaCost = 9, statInterpolation = { }, },
		[20] = { damageMultiplier = -9.5, levelRequirement = 70, manaCost = 9, statInterpolation = { }, },
		[21] = { damageMultiplier = -7.6, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { damageMultiplier = -5.6, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { damageMultiplier = -3.7, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { damageMultiplier = -1.8, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { manaCost = 10, levelRequirement = 80, statInterpolation = { }, },
		[26] = { damageMultiplier = 2, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { damageMultiplier = 3.9, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { damageMultiplier = 5.8, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { damageMultiplier = 7.7, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { damageMultiplier = 9.6, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["VaalThrownWeapon"] = {
	name = "Vaal Spectral Throw",
	color = 2,
	description = "Throws a spectral copy of your melee weapon. It spirals out in a spinning attack that strikes enemies in its path.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [6] = true, [43] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"projectiles_nova",
		"base_is_projectile",
		"global_always_hit",
	},
	levels = {
		[1] = { damageMultiplier = -30, levelRequirement = 1, statInterpolation = { }, },
		[2] = { damageMultiplier = -28.2, levelRequirement = 2, statInterpolation = { }, },
		[3] = { damageMultiplier = -26.4, levelRequirement = 4, statInterpolation = { }, },
		[4] = { damageMultiplier = -24.6, levelRequirement = 7, statInterpolation = { }, },
		[5] = { damageMultiplier = -22.8, levelRequirement = 11, statInterpolation = { }, },
		[6] = { damageMultiplier = -21, levelRequirement = 16, statInterpolation = { }, },
		[7] = { damageMultiplier = -19.2, levelRequirement = 20, statInterpolation = { }, },
		[8] = { damageMultiplier = -17.4, levelRequirement = 24, statInterpolation = { }, },
		[9] = { damageMultiplier = -15.6, levelRequirement = 28, statInterpolation = { }, },
		[10] = { damageMultiplier = -13.8, levelRequirement = 32, statInterpolation = { }, },
		[11] = { damageMultiplier = -12, levelRequirement = 36, statInterpolation = { }, },
		[12] = { damageMultiplier = -10.2, levelRequirement = 40, statInterpolation = { }, },
		[13] = { damageMultiplier = -8.4, levelRequirement = 44, statInterpolation = { }, },
		[14] = { damageMultiplier = -6.6, levelRequirement = 48, statInterpolation = { }, },
		[15] = { damageMultiplier = -4.8, levelRequirement = 52, statInterpolation = { }, },
		[16] = { damageMultiplier = -3, levelRequirement = 56, statInterpolation = { }, },
		[17] = { damageMultiplier = -1.2, levelRequirement = 60, statInterpolation = { }, },
		[18] = { damageMultiplier = 0.6, levelRequirement = 64, statInterpolation = { }, },
		[19] = { damageMultiplier = 2.4, levelRequirement = 67, statInterpolation = { }, },
		[20] = { damageMultiplier = 4.2, levelRequirement = 70, statInterpolation = { }, },
		[21] = { damageMultiplier = 6, levelRequirement = 72, statInterpolation = { }, },
		[22] = { damageMultiplier = 7.8, levelRequirement = 74, statInterpolation = { }, },
		[23] = { damageMultiplier = 9.6, levelRequirement = 76, statInterpolation = { }, },
		[24] = { damageMultiplier = 11.4, levelRequirement = 78, statInterpolation = { }, },
		[25] = { damageMultiplier = 13.2, levelRequirement = 80, statInterpolation = { }, },
		[26] = { damageMultiplier = 15, levelRequirement = 82, statInterpolation = { }, },
		[27] = { damageMultiplier = 16.8, levelRequirement = 84, statInterpolation = { }, },
		[28] = { damageMultiplier = 18.6, levelRequirement = 86, statInterpolation = { }, },
		[29] = { damageMultiplier = 20.4, levelRequirement = 88, statInterpolation = { }, },
		[30] = { damageMultiplier = 22.2, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["SplitArrow"] = {
	name = "Split Arrow",
	color = 2,
	description = "Fires multiple arrows at different targets.",
	skillTypes = { [1] = true, [48] = true, [3] = true, [22] = true, [17] = true, [19] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_number_of_additional_arrows",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 4, damageMultiplier = -10, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 4, damageMultiplier = -9, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 4, damageMultiplier = -8, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 4, damageMultiplier = -7, levelRequirement = 7, manaCost = 7, statInterpolation = { }, },
		[5] = { 4, damageMultiplier = -6, levelRequirement = 11, manaCost = 7, statInterpolation = { }, },
		[6] = { 4, damageMultiplier = -5, levelRequirement = 16, manaCost = 7, statInterpolation = { }, },
		[7] = { 4, damageMultiplier = -4, levelRequirement = 20, manaCost = 7, statInterpolation = { }, },
		[8] = { 5, damageMultiplier = -3, levelRequirement = 24, manaCost = 8, statInterpolation = { }, },
		[9] = { 5, damageMultiplier = -2, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[10] = { 5, damageMultiplier = -1, levelRequirement = 32, manaCost = 8, statInterpolation = { }, },
		[11] = { 5, manaCost = 8, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 5, damageMultiplier = 1, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[13] = { 5, damageMultiplier = 2, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[14] = { 5, damageMultiplier = 3, levelRequirement = 48, manaCost = 9, statInterpolation = { }, },
		[15] = { 6, damageMultiplier = 4, levelRequirement = 52, manaCost = 9, statInterpolation = { }, },
		[16] = { 6, damageMultiplier = 5, levelRequirement = 56, manaCost = 9, statInterpolation = { }, },
		[17] = { 6, damageMultiplier = 6, levelRequirement = 60, manaCost = 9, statInterpolation = { }, },
		[18] = { 6, damageMultiplier = 7, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[19] = { 6, damageMultiplier = 8, levelRequirement = 67, manaCost = 10, statInterpolation = { }, },
		[20] = { 6, damageMultiplier = 9, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 6, damageMultiplier = 10, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 7, damageMultiplier = 11, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 7, damageMultiplier = 12, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 7, damageMultiplier = 13, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 7, damageMultiplier = 14, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 7, damageMultiplier = 15, levelRequirement = 82, manaCost = 11, statInterpolation = { }, },
		[27] = { 7, damageMultiplier = 16, levelRequirement = 84, manaCost = 11, statInterpolation = { }, },
		[28] = { 7, damageMultiplier = 17, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 8, damageMultiplier = 18, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 8, damageMultiplier = 19, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["SummonIceGolem"] = {
	name = "Summon Ice Golem",
	color = 2,
	description = "Summons an Ice Golem that grants you increased Critical Strike Chance and Accuracy. The Ice Golem can use an icy barrage spell and a chilling spinning dash in addition to its melee attack.",
	skillTypes = { [36] = true, [34] = true, [19] = true, [9] = true, [21] = true, [26] = true, [2] = true, [18] = true, [17] = true, [49] = true, [60] = true, [62] = true, },
	minionSkillTypes = { [1] = true, [24] = true, [25] = true, [3] = true, [2] = true, [10] = true, [38] = true, [28] = true, },
	castTime = 1,
	minionList = {
		"SummonedIceGolem",
	},
	statMap = {
		["ice_golem_grants_critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["ice_golem_grants_accuracy_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveColdGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		{ "minion_maximum_life_+%", 1 },
		{ "minion_damage_+%", 1 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_golems_allowed",
		"ice_golem_grants_critical_strike_chance_+%",
		"ice_golem_grants_accuracy_+%",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
	},
	levels = {
		[1] = { 0, 1, 20, 20, 30, 6, 34, cooldown = 6, levelRequirement = 34, manaCost = 30, statInterpolation = { }, },
		[2] = { 1, 1, 21, 21, 32, 6, 36, cooldown = 6, levelRequirement = 36, manaCost = 32, statInterpolation = { }, },
		[3] = { 1, 1, 21, 21, 34, 6, 38, cooldown = 6, levelRequirement = 38, manaCost = 34, statInterpolation = { }, },
		[4] = { 2, 1, 22, 22, 36, 6, 40, cooldown = 6, levelRequirement = 40, manaCost = 36, statInterpolation = { }, },
		[5] = { 2, 1, 22, 22, 38, 6, 42, cooldown = 6, levelRequirement = 42, manaCost = 38, statInterpolation = { }, },
		[6] = { 3, 1, 23, 23, 40, 6, 44, cooldown = 6, levelRequirement = 44, manaCost = 40, statInterpolation = { }, },
		[7] = { 3, 1, 23, 23, 42, 6, 46, cooldown = 6, levelRequirement = 46, manaCost = 42, statInterpolation = { }, },
		[8] = { 4, 1, 24, 24, 44, 6, 48, cooldown = 6, levelRequirement = 48, manaCost = 44, statInterpolation = { }, },
		[9] = { 4, 1, 24, 24, 46, 6, 50, cooldown = 6, levelRequirement = 50, manaCost = 44, statInterpolation = { }, },
		[10] = { 5, 1, 25, 25, 48, 6, 52, cooldown = 6, levelRequirement = 52, manaCost = 46, statInterpolation = { }, },
		[11] = { 5, 1, 25, 25, 50, 6, 54, cooldown = 6, levelRequirement = 54, manaCost = 48, statInterpolation = { }, },
		[12] = { 6, 1, 26, 26, 52, 6, 56, cooldown = 6, levelRequirement = 56, manaCost = 48, statInterpolation = { }, },
		[13] = { 6, 1, 26, 26, 54, 6, 58, cooldown = 6, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[14] = { 7, 1, 27, 27, 56, 6, 60, cooldown = 6, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[15] = { 7, 1, 27, 27, 58, 6, 62, cooldown = 6, levelRequirement = 62, manaCost = 52, statInterpolation = { }, },
		[16] = { 8, 1, 28, 28, 60, 6, 64, cooldown = 6, levelRequirement = 64, manaCost = 52, statInterpolation = { }, },
		[17] = { 8, 1, 28, 28, 62, 6, 66, cooldown = 6, levelRequirement = 66, manaCost = 52, statInterpolation = { }, },
		[18] = { 9, 1, 29, 29, 64, 6, 68, cooldown = 6, levelRequirement = 68, manaCost = 52, statInterpolation = { }, },
		[19] = { 9, 1, 29, 29, 66, 6, 69, cooldown = 6, levelRequirement = 69, manaCost = 54, statInterpolation = { }, },
		[20] = { 10, 1, 30, 30, 68, 6, 70, cooldown = 6, levelRequirement = 70, manaCost = 54, statInterpolation = { }, },
		[21] = { 10, 1, 30, 30, 70, 6, 72, cooldown = 6, levelRequirement = 72, manaCost = 56, statInterpolation = { }, },
		[22] = { 11, 1, 31, 31, 72, 6, 74, cooldown = 6, levelRequirement = 74, manaCost = 56, statInterpolation = { }, },
		[23] = { 11, 1, 31, 31, 74, 6, 76, cooldown = 6, levelRequirement = 76, manaCost = 58, statInterpolation = { }, },
		[24] = { 12, 1, 32, 32, 76, 6, 78, cooldown = 6, levelRequirement = 78, manaCost = 58, statInterpolation = { }, },
		[25] = { 12, 1, 32, 32, 78, 6, 80, cooldown = 6, levelRequirement = 80, manaCost = 60, statInterpolation = { }, },
		[26] = { 13, 1, 33, 33, 80, 6, 82, cooldown = 6, levelRequirement = 82, manaCost = 60, statInterpolation = { }, },
		[27] = { 13, 1, 33, 33, 82, 6, 84, cooldown = 6, levelRequirement = 84, manaCost = 60, statInterpolation = { }, },
		[28] = { 14, 1, 34, 34, 84, 6, 86, cooldown = 6, levelRequirement = 86, manaCost = 60, statInterpolation = { }, },
		[29] = { 14, 1, 34, 34, 86, 6, 88, cooldown = 6, levelRequirement = 88, manaCost = 62, statInterpolation = { }, },
		[30] = { 15, 1, 35, 35, 88, 6, 90, cooldown = 6, levelRequirement = 90, manaCost = 62, statInterpolation = { }, },
	},
}
skills["TemporalChains"] = {
	name = "Temporal Chains",
	color = 2,
	description = "Curses all targets in an area, Slowing them, and making effects on them expire more slowly.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [26] = true, [32] = true, [36] = true, },
	castTime = 0.5,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["buff_time_passed_-%"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
			mult = -1,
		},
		["curse_effect_+%_vs_players"] = {
			mod("CurseEffectAgainstPlayer", "INC", nil),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "temporal_chains_action_speed_+%_final", -0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_area_of_effect_+%",
		"temporal_chains_action_speed_+%_final",
		"buff_time_passed_-%",
		"curse_effect_+%_vs_players",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 5000, 0, -20, 40, -40, manaCost = 24, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 5050, 4, -20, 40, -40, manaCost = 26, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 5100, 8, -21, 40, -40, manaCost = 27, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 5150, 12, -21, 40, -40, manaCost = 29, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 5200, 16, -22, 40, -40, manaCost = 30, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 5250, 20, -22, 40, -40, manaCost = 32, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 5300, 24, -23, 40, -40, manaCost = 34, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 5350, 28, -23, 40, -40, manaCost = 35, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 5400, 32, -24, 40, -40, manaCost = 37, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 5450, 36, -24, 40, -40, manaCost = 38, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 5500, 40, -25, 40, -40, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 5550, 44, -25, 40, -40, manaCost = 40, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 5600, 48, -26, 40, -40, manaCost = 42, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 5650, 52, -26, 40, -40, manaCost = 43, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 5700, 56, -27, 40, -40, manaCost = 44, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 5750, 60, -27, 40, -40, manaCost = 45, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 5800, 64, -28, 40, -40, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 5850, 68, -28, 40, -40, manaCost = 47, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 5900, 72, -29, 40, -40, manaCost = 48, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 5950, 76, -29, 40, -40, manaCost = 50, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 6000, 80, -30, 40, -40, manaCost = 51, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 6050, 84, -30, 40, -40, manaCost = 52, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 6100, 88, -31, 40, -40, manaCost = 53, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 6150, 92, -31, 40, -40, manaCost = 54, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 6200, 96, -32, 40, -40, manaCost = 56, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 6250, 100, -32, 40, -40, manaCost = 57, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 6300, 104, -33, 40, -40, manaCost = 58, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 6350, 108, -33, 40, -40, manaCost = 59, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 6400, 112, -34, 40, -40, manaCost = 60, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 6450, 116, -34, 40, -40, manaCost = 61, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["TornadoShot"] = {
	name = "Tornado Shot",
	color = 2,
	description = "Fires a piercing shot that travels until it reaches the targeted location. It will then fire projectiles out in all directions from that point.",
	skillTypes = { [1] = true, [3] = true, [17] = true, [19] = true, [22] = true, [48] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "projectile_damage_+%", 1 },
	},
	stats = {
		"tornado_shot_num_of_secondary_projectiles",
		"base_is_projectile",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 3, damageMultiplier = -10, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[2] = { 3, damageMultiplier = -9, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[3] = { 3, damageMultiplier = -8, levelRequirement = 34, manaCost = 8, statInterpolation = { }, },
		[4] = { 3, damageMultiplier = -7, levelRequirement = 37, manaCost = 8, statInterpolation = { }, },
		[5] = { 3, damageMultiplier = -6, levelRequirement = 40, manaCost = 9, statInterpolation = { }, },
		[6] = { 3, damageMultiplier = -5, levelRequirement = 42, manaCost = 9, statInterpolation = { }, },
		[7] = { 3, damageMultiplier = -4, levelRequirement = 44, manaCost = 9, statInterpolation = { }, },
		[8] = { 3, damageMultiplier = -3, levelRequirement = 46, manaCost = 9, statInterpolation = { }, },
		[9] = { 3, damageMultiplier = -2, levelRequirement = 48, manaCost = 9, statInterpolation = { }, },
		[10] = { 3, damageMultiplier = -1, levelRequirement = 50, manaCost = 9, statInterpolation = { }, },
		[11] = { 3, manaCost = 9, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 3, damageMultiplier = 1, levelRequirement = 54, manaCost = 10, statInterpolation = { }, },
		[13] = { 3, damageMultiplier = 2, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[14] = { 3, damageMultiplier = 3, levelRequirement = 58, manaCost = 10, statInterpolation = { }, },
		[15] = { 3, damageMultiplier = 4, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[16] = { 3, damageMultiplier = 5, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 3, damageMultiplier = 6, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 3, damageMultiplier = 7, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 3, damageMultiplier = 8, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 3, damageMultiplier = 9, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 3, damageMultiplier = 10, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 3, damageMultiplier = 11, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 3, damageMultiplier = 12, levelRequirement = 76, manaCost = 11, statInterpolation = { }, },
		[24] = { 3, damageMultiplier = 13, levelRequirement = 78, manaCost = 11, statInterpolation = { }, },
		[25] = { 3, damageMultiplier = 14, levelRequirement = 80, manaCost = 11, statInterpolation = { }, },
		[26] = { 3, damageMultiplier = 15, levelRequirement = 82, manaCost = 11, statInterpolation = { }, },
		[27] = { 3, damageMultiplier = 16, levelRequirement = 84, manaCost = 11, statInterpolation = { }, },
		[28] = { 3, damageMultiplier = 17, levelRequirement = 86, manaCost = 12, statInterpolation = { }, },
		[29] = { 3, damageMultiplier = 18, levelRequirement = 88, manaCost = 12, statInterpolation = { }, },
		[30] = { 3, damageMultiplier = 19, levelRequirement = 90, manaCost = 12, statInterpolation = { }, },
	},
}
skills["ViperStrike"] = {
	name = "Viper Strike",
	color = 2,
	description = "Hits the enemy, adding some of your physical damage as chaos damage and applying poison. Requires a claw, dagger or sword.",
	skillTypes = { [1] = true, [6] = true, [12] = true, [28] = true, [24] = true, [25] = true, [40] = true, [50] = true, },
	weaponTypes = {
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"base_physical_damage_%_to_convert_to_chaos",
		"base_chance_to_poison_on_hit_%",
		"base_skill_effect_duration",
		"poison_duration_is_skill_duration",
	},
	levels = {
		[1] = { 25, 100, 8000, damageMultiplier = 30, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 25, 100, 8000, damageMultiplier = 32.6, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { 25, 100, 8000, damageMultiplier = 35.2, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { 25, 100, 8000, damageMultiplier = 37.8, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { 25, 100, 8000, damageMultiplier = 40.4, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { 25, 100, 8000, damageMultiplier = 43, levelRequirement = 16, manaCost = 5, statInterpolation = { }, },
		[7] = { 25, 100, 8000, damageMultiplier = 45.6, levelRequirement = 20, manaCost = 5, statInterpolation = { }, },
		[8] = { 25, 100, 8000, damageMultiplier = 48.2, levelRequirement = 24, manaCost = 5, statInterpolation = { }, },
		[9] = { 25, 100, 8000, damageMultiplier = 50.8, levelRequirement = 28, manaCost = 5, statInterpolation = { }, },
		[10] = { 25, 100, 8000, damageMultiplier = 53.4, levelRequirement = 32, manaCost = 5, statInterpolation = { }, },
		[11] = { 25, 100, 8000, damageMultiplier = 56, levelRequirement = 36, manaCost = 5, statInterpolation = { }, },
		[12] = { 25, 100, 8000, damageMultiplier = 58.6, levelRequirement = 40, manaCost = 5, statInterpolation = { }, },
		[13] = { 25, 100, 8000, damageMultiplier = 61.2, levelRequirement = 44, manaCost = 5, statInterpolation = { }, },
		[14] = { 25, 100, 8000, damageMultiplier = 63.8, levelRequirement = 48, manaCost = 5, statInterpolation = { }, },
		[15] = { 25, 100, 8000, damageMultiplier = 66.4, levelRequirement = 52, manaCost = 5, statInterpolation = { }, },
		[16] = { 25, 100, 8000, damageMultiplier = 69, levelRequirement = 56, manaCost = 5, statInterpolation = { }, },
		[17] = { 25, 100, 8000, damageMultiplier = 71.6, levelRequirement = 60, manaCost = 5, statInterpolation = { }, },
		[18] = { 25, 100, 8000, damageMultiplier = 74.2, levelRequirement = 64, manaCost = 5, statInterpolation = { }, },
		[19] = { 25, 100, 8000, damageMultiplier = 76.8, levelRequirement = 67, manaCost = 5, statInterpolation = { }, },
		[20] = { 25, 100, 8000, damageMultiplier = 79.4, levelRequirement = 70, manaCost = 5, statInterpolation = { }, },
		[21] = { 25, 100, 8000, damageMultiplier = 82, levelRequirement = 72, manaCost = 5, statInterpolation = { }, },
		[22] = { 25, 100, 8000, damageMultiplier = 84.6, levelRequirement = 74, manaCost = 5, statInterpolation = { }, },
		[23] = { 25, 100, 8000, damageMultiplier = 87.2, levelRequirement = 76, manaCost = 5, statInterpolation = { }, },
		[24] = { 25, 100, 8000, damageMultiplier = 89.8, levelRequirement = 78, manaCost = 5, statInterpolation = { }, },
		[25] = { 25, 100, 8000, damageMultiplier = 92.4, levelRequirement = 80, manaCost = 5, statInterpolation = { }, },
		[26] = { 25, 100, 8000, damageMultiplier = 95, levelRequirement = 82, manaCost = 5, statInterpolation = { }, },
		[27] = { 25, 100, 8000, damageMultiplier = 97.6, levelRequirement = 84, manaCost = 5, statInterpolation = { }, },
		[28] = { 25, 100, 8000, damageMultiplier = 100.2, levelRequirement = 86, manaCost = 5, statInterpolation = { }, },
		[29] = { 25, 100, 8000, damageMultiplier = 102.8, levelRequirement = 88, manaCost = 5, statInterpolation = { }, },
		[30] = { 25, 100, 8000, damageMultiplier = 105.4, levelRequirement = 90, manaCost = 5, statInterpolation = { }, },
	},
}
skills["WhirlingBlades"] = {
	name = "Whirling Blades",
	color = 2,
	description = "Dive through enemies, dealing weapon damage. Only works with daggers, claws and one handed swords.",
	skillTypes = { [1] = true, [6] = true, [24] = true, [38] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 2.6,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { damageMultiplier = -20, levelRequirement = 10, manaCost = 15, statInterpolation = { }, },
		[2] = { damageMultiplier = -19, levelRequirement = 13, manaCost = 15, statInterpolation = { }, },
		[3] = { damageMultiplier = -18, levelRequirement = 17, manaCost = 15, statInterpolation = { }, },
		[4] = { damageMultiplier = -17, levelRequirement = 21, manaCost = 15, statInterpolation = { }, },
		[5] = { damageMultiplier = -16, levelRequirement = 25, manaCost = 15, statInterpolation = { }, },
		[6] = { damageMultiplier = -15, levelRequirement = 29, manaCost = 15, statInterpolation = { }, },
		[7] = { damageMultiplier = -14, levelRequirement = 33, manaCost = 15, statInterpolation = { }, },
		[8] = { damageMultiplier = -13, levelRequirement = 36, manaCost = 15, statInterpolation = { }, },
		[9] = { damageMultiplier = -12, levelRequirement = 39, manaCost = 15, statInterpolation = { }, },
		[10] = { damageMultiplier = -11, levelRequirement = 42, manaCost = 15, statInterpolation = { }, },
		[11] = { damageMultiplier = -10, levelRequirement = 45, manaCost = 15, statInterpolation = { }, },
		[12] = { damageMultiplier = -9, levelRequirement = 48, manaCost = 15, statInterpolation = { }, },
		[13] = { damageMultiplier = -8, levelRequirement = 51, manaCost = 15, statInterpolation = { }, },
		[14] = { damageMultiplier = -7, levelRequirement = 54, manaCost = 15, statInterpolation = { }, },
		[15] = { damageMultiplier = -6, levelRequirement = 57, manaCost = 15, statInterpolation = { }, },
		[16] = { damageMultiplier = -5, levelRequirement = 60, manaCost = 15, statInterpolation = { }, },
		[17] = { damageMultiplier = -4, levelRequirement = 63, manaCost = 15, statInterpolation = { }, },
		[18] = { damageMultiplier = -3, levelRequirement = 66, manaCost = 15, statInterpolation = { }, },
		[19] = { damageMultiplier = -2, levelRequirement = 68, manaCost = 15, statInterpolation = { }, },
		[20] = { damageMultiplier = -1, levelRequirement = 70, manaCost = 15, statInterpolation = { }, },
		[21] = { manaCost = 15, levelRequirement = 72, statInterpolation = { }, },
		[22] = { damageMultiplier = 1, levelRequirement = 74, manaCost = 15, statInterpolation = { }, },
		[23] = { damageMultiplier = 2, levelRequirement = 76, manaCost = 15, statInterpolation = { }, },
		[24] = { damageMultiplier = 3, levelRequirement = 78, manaCost = 15, statInterpolation = { }, },
		[25] = { damageMultiplier = 4, levelRequirement = 80, manaCost = 15, statInterpolation = { }, },
		[26] = { damageMultiplier = 5, levelRequirement = 82, manaCost = 15, statInterpolation = { }, },
		[27] = { damageMultiplier = 6, levelRequirement = 84, manaCost = 15, statInterpolation = { }, },
		[28] = { damageMultiplier = 7, levelRequirement = 86, manaCost = 15, statInterpolation = { }, },
		[29] = { damageMultiplier = 8, levelRequirement = 88, manaCost = 15, statInterpolation = { }, },
		[30] = { damageMultiplier = 9, levelRequirement = 90, manaCost = 15, statInterpolation = { }, },
	},
}
skills["WildStrike"] = {
	name = "Wild Strike",
	color = 2,
	description = "Your melee weapon strikes an enemy, converting some of the damage to a random element. Then, depending on the element chosen, it releases an explosion, an arcing bolt of lightning, or an icy wave.",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, [35] = true, [34] = true, [33] = true, [3] = true, [11] = true, [23] = true, [48] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Fire hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Fire explosion",
			melee = false,
			projectile = false,
			chaining = false,
			area = true,
		},
		{
			name = "Lightning hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Lightning bolt",
			melee = false,
			projectile = false,
			chaining = true,
			area = false,
		},
		{
			name = "Cold hit",
			melee = true,
			projectile = false,
			chaining = false,
			area = false,
		},
		{
			name = "Icy wave",
			melee = false,
			projectile = true,
			chaining = false,
			area = false,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		chaining = true,
		area = true,
	},
	baseMods = {
		mod("PhysicalDamageConvertToFire", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 1, 2 } }),
		mod("PhysicalDamageConvertToLightning", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 3, 4 } }),
		mod("PhysicalDamageConvertToCold", "BASE", 100, 0, 0, { type = "SkillPart", skillPartList =  { 5, 6 } }),
	},
	qualityStats = {
		{ "elemental_damage_+%", 1 },
	},
	stats = {
		"elemental_strike_physical_damage_%_to_convert",
		"number_of_additional_projectiles_in_chain",
		"fixed_projectile_spread",
		"number_of_additional_projectiles",
		"base_skill_area_of_effect_+%",
		"show_number_of_projectiles",
		"always_pierce",
	},
	levels = {
		[1] = { 100, 4, 70, 2, 0, damageMultiplier = 30, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[2] = { 100, 4, 70, 2, 1, damageMultiplier = 32.4, levelRequirement = 31, manaCost = 6, statInterpolation = { }, },
		[3] = { 100, 4, 70, 2, 2, damageMultiplier = 34.8, levelRequirement = 34, manaCost = 6, statInterpolation = { }, },
		[4] = { 100, 4, 70, 2, 3, damageMultiplier = 37.2, levelRequirement = 37, manaCost = 6, statInterpolation = { }, },
		[5] = { 100, 4, 70, 2, 4, damageMultiplier = 39.6, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[6] = { 100, 4, 70, 2, 5, damageMultiplier = 42, levelRequirement = 42, manaCost = 6, statInterpolation = { }, },
		[7] = { 100, 5, 70, 2, 6, damageMultiplier = 44.4, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[8] = { 100, 5, 70, 2, 7, damageMultiplier = 46.8, levelRequirement = 46, manaCost = 6, statInterpolation = { }, },
		[9] = { 100, 5, 70, 2, 8, damageMultiplier = 49.2, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[10] = { 100, 5, 70, 2, 9, damageMultiplier = 51.6, levelRequirement = 50, manaCost = 6, statInterpolation = { }, },
		[11] = { 100, 5, 70, 2, 10, damageMultiplier = 54, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[12] = { 100, 5, 70, 2, 11, damageMultiplier = 56.4, levelRequirement = 54, manaCost = 6, statInterpolation = { }, },
		[13] = { 100, 6, 70, 2, 12, damageMultiplier = 58.8, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[14] = { 100, 6, 70, 2, 13, damageMultiplier = 61.2, levelRequirement = 58, manaCost = 6, statInterpolation = { }, },
		[15] = { 100, 6, 70, 2, 14, damageMultiplier = 63.6, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[16] = { 100, 6, 70, 2, 15, damageMultiplier = 66, levelRequirement = 62, manaCost = 6, statInterpolation = { }, },
		[17] = { 100, 6, 70, 2, 16, damageMultiplier = 68.4, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[18] = { 100, 6, 70, 2, 17, damageMultiplier = 70.8, levelRequirement = 66, manaCost = 6, statInterpolation = { }, },
		[19] = { 100, 7, 70, 2, 18, damageMultiplier = 73.2, levelRequirement = 68, manaCost = 6, statInterpolation = { }, },
		[20] = { 100, 7, 70, 2, 19, damageMultiplier = 75.6, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 100, 7, 70, 2, 20, damageMultiplier = 78, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 100, 7, 70, 2, 21, damageMultiplier = 80.4, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 100, 7, 70, 2, 22, damageMultiplier = 82.8, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 100, 7, 70, 2, 23, damageMultiplier = 85.2, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 100, 8, 70, 2, 24, damageMultiplier = 87.6, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 100, 8, 70, 2, 25, damageMultiplier = 90, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 100, 8, 70, 2, 26, damageMultiplier = 92.4, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 100, 8, 70, 2, 27, damageMultiplier = 94.8, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 100, 8, 70, 2, 28, damageMultiplier = 97.2, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 100, 8, 70, 2, 29, damageMultiplier = 99.6, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}